package org.hildan.chrome.devtools.domains.domstorage

import kotlin.Boolean
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable

/**
 * DOM Storage identifier.
 */
@Serializable
public data class StorageId(
  /**
   * Security origin for the storage.
   */
  public val securityOrigin: String,
  /**
   * Whether the storage is local storage (not session storage).
   */
  public val isLocalStorage: Boolean
)

/**
 * DOM Storage item.
 */
public typealias Item = List<String>
