package org.hildan.chrome.devtools.domains.domstorage.events

import kotlin.String
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.domstorage.StorageId

@Serializable
public sealed class DOMStorageEvent {
  @Serializable
  public data class DomStorageItemAddedEvent(
    public val storageId: StorageId,
    public val key: String,
    public val newValue: String
  ) : DOMStorageEvent()

  @Serializable
  public data class DomStorageItemRemovedEvent(
    public val storageId: StorageId,
    public val key: String
  ) : DOMStorageEvent()

  @Serializable
  public data class DomStorageItemUpdatedEvent(
    public val storageId: StorageId,
    public val key: String,
    public val oldValue: String,
    public val newValue: String
  ) : DOMStorageEvent()

  @Serializable
  public data class DomStorageItemsClearedEvent(
    public val storageId: StorageId
  ) : DOMStorageEvent()
}
