package org.hildan.chrome.devtools.domains.heapprofiler.events

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable

@Serializable
public sealed class HeapProfilerEvent {
  @Serializable
  public data class AddHeapSnapshotChunkEvent(
    public val chunk: String
  ) : HeapProfilerEvent()

  @Serializable
  public data class HeapStatsUpdateEvent(
    /**
     * An array of triplets. Each triplet describes a fragment. The first integer is the fragment
     * index, the second integer is a total count of objects for the fragment, the third integer is
     * a total size of the objects for the fragment.
     */
    public val statsUpdate: List<Int>
  ) : HeapProfilerEvent()

  @Serializable
  public data class LastSeenObjectIdEvent(
    public val lastSeenObjectId: Int,
    public val timestamp: Double
  ) : HeapProfilerEvent()

  @Serializable
  public data class ReportHeapSnapshotProgressEvent(
    public val done: Int,
    public val total: Int,
    public val finished: Boolean? = null
  ) : HeapProfilerEvent()

  @Serializable
  public object ResetProfilesEvent : HeapProfilerEvent()
}
