package org.hildan.chrome.devtools.domains.inspector.events

import kotlin.String
import kotlinx.serialization.Serializable

@Serializable
public sealed class InspectorEvent {
  @Serializable
  public data class DetachedEvent(
    /**
     * The reason why connection has been terminated.
     */
    public val reason: String
  ) : InspectorEvent()

  @Serializable
  public object TargetCrashedEvent : InspectorEvent()

  @Serializable
  public object TargetReloadedAfterCrashEvent : InspectorEvent()
}
