package org.hildan.chrome.devtools.domains.layertree.events

import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.dom.Rect
import org.hildan.chrome.devtools.domains.layertree.Layer
import org.hildan.chrome.devtools.domains.layertree.LayerId

@Serializable
public sealed class LayerTreeEvent {
  @Serializable
  public data class LayerPaintedEvent(
    /**
     * The id of the painted layer.
     */
    public val layerId: LayerId,
    /**
     * Clip rectangle.
     */
    public val clip: Rect
  ) : LayerTreeEvent()

  @Serializable
  public data class LayerTreeDidChangeEvent(
    /**
     * Layer tree, absent if not in the comspositing mode.
     */
    public val layers: List<Layer>? = null
  ) : LayerTreeEvent()
}
