package org.hildan.chrome.devtools.domains.overlay.events

import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.dom.BackendNodeId
import org.hildan.chrome.devtools.domains.dom.NodeId
import org.hildan.chrome.devtools.domains.page.Viewport

@Serializable
public sealed class OverlayEvent {
  @Serializable
  public data class InspectNodeRequestedEvent(
    /**
     * Id of the node to inspect.
     */
    public val backendNodeId: BackendNodeId
  ) : OverlayEvent()

  @Serializable
  public data class NodeHighlightRequestedEvent(
    public val nodeId: NodeId
  ) : OverlayEvent()

  @Serializable
  public data class ScreenshotRequestedEvent(
    /**
     * Viewport to capture, in device independent pixels (dip).
     */
    public val viewport: Viewport
  ) : OverlayEvent()

  @Serializable
  public object InspectModeCanceledEvent : OverlayEvent()
}
