package org.hildan.chrome.devtools.domains.serviceworker.events

import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.serviceworker.ServiceWorkerErrorMessage
import org.hildan.chrome.devtools.domains.serviceworker.ServiceWorkerRegistration
import org.hildan.chrome.devtools.domains.serviceworker.ServiceWorkerVersion

@Serializable
public sealed class ServiceWorkerEvent {
  @Serializable
  public data class WorkerErrorReportedEvent(
    public val errorMessage: ServiceWorkerErrorMessage
  ) : ServiceWorkerEvent()

  @Serializable
  public data class WorkerRegistrationUpdatedEvent(
    public val registrations: List<ServiceWorkerRegistration>
  ) : ServiceWorkerEvent()

  @Serializable
  public data class WorkerVersionUpdatedEvent(
    public val versions: List<ServiceWorkerVersion>
  ) : ServiceWorkerEvent()
}
