package org.hildan.chrome.devtools.domains.storage

import kotlin.Double
import kotlinx.serialization.Serializable

/**
 * Enum of possible storage types.
 */
@Serializable
public enum class StorageType {
  appcache,
  cookies,
  file_systems,
  indexeddb,
  local_storage,
  shader_cache,
  websql,
  service_workers,
  cache_storage,
  all,
  other,
}

/**
 * Usage for a storage type.
 */
@Serializable
public data class UsageForType(
  /**
   * Name of storage type.
   */
  public val storageType: StorageType,
  /**
   * Storage usage (bytes).
   */
  public val usage: Double
)
