package org.hildan.chrome.devtools.domains.target

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.browser.BrowserContextID
import org.hildan.chrome.devtools.domains.page.FrameId
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

public typealias TargetID = String

/**
 * Unique identifier of attached debugging session.
 */
public typealias SessionID = String

@Serializable
public data class TargetInfo(
  public val targetId: TargetID,
  public val type: String,
  public val title: String,
  public val url: String,
  /**
   * Whether the target has an attached client.
   */
  public val attached: Boolean,
  /**
   * Opener target Id
   */
  public val openerId: TargetID? = null,
  /**
   * Whether the target has access to the originating window.
   */
  @ExperimentalChromeApi
  public val canAccessOpener: Boolean? = null,
  /**
   * Frame id of originating window (is only set if target has an opener).
   */
  @ExperimentalChromeApi
  public val openerFrameId: FrameId? = null,
  @ExperimentalChromeApi
  public val browserContextId: BrowserContextID? = null
)

@ExperimentalChromeApi
@Serializable
public data class RemoteLocation(
  public val host: String,
  public val port: Int
)
