package org.hildan.chrome.devtools.domains.target.events

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.target.SessionID
import org.hildan.chrome.devtools.domains.target.TargetID
import org.hildan.chrome.devtools.domains.target.TargetInfo

@Serializable
public sealed class TargetEvent {
  @Serializable
  public data class AttachedToTargetEvent(
    /**
     * Identifier assigned to the session used to send/receive messages.
     */
    public val sessionId: SessionID,
    public val targetInfo: TargetInfo,
    public val waitingForDebugger: Boolean
  ) : TargetEvent()

  @Serializable
  public data class DetachedFromTargetEvent(
    /**
     * Detached session identifier.
     */
    public val sessionId: SessionID,
    /**
     * Deprecated.
     */
    @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
    public val targetId: TargetID? = null
  ) : TargetEvent()

  @Serializable
  public data class ReceivedMessageFromTargetEvent(
    /**
     * Identifier of a session which sends a message.
     */
    public val sessionId: SessionID,
    public val message: String,
    /**
     * Deprecated.
     */
    @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
    public val targetId: TargetID? = null
  ) : TargetEvent()

  @Serializable
  public data class TargetCreatedEvent(
    public val targetInfo: TargetInfo
  ) : TargetEvent()

  @Serializable
  public data class TargetDestroyedEvent(
    public val targetId: TargetID
  ) : TargetEvent()

  @Serializable
  public data class TargetCrashedEvent(
    public val targetId: TargetID,
    /**
     * Termination status type.
     */
    public val status: String,
    /**
     * Termination error code.
     */
    public val errorCode: Int
  ) : TargetEvent()

  @Serializable
  public data class TargetInfoChangedEvent(
    public val targetInfo: TargetInfo
  ) : TargetEvent()
}
