package org.hildan.chrome.devtools.domains.webaudio.events

import kotlin.Double
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.webaudio.AudioListener
import org.hildan.chrome.devtools.domains.webaudio.AudioNode
import org.hildan.chrome.devtools.domains.webaudio.AudioParam
import org.hildan.chrome.devtools.domains.webaudio.BaseAudioContext
import org.hildan.chrome.devtools.domains.webaudio.GraphObjectId

@Serializable
public sealed class WebAudioEvent {
  @Serializable
  public data class ContextCreatedEvent(
    public val context: BaseAudioContext
  ) : WebAudioEvent()

  @Serializable
  public data class ContextWillBeDestroyedEvent(
    public val contextId: GraphObjectId
  ) : WebAudioEvent()

  @Serializable
  public data class ContextChangedEvent(
    public val context: BaseAudioContext
  ) : WebAudioEvent()

  @Serializable
  public data class AudioListenerCreatedEvent(
    public val listener: AudioListener
  ) : WebAudioEvent()

  @Serializable
  public data class AudioListenerWillBeDestroyedEvent(
    public val contextId: GraphObjectId,
    public val listenerId: GraphObjectId
  ) : WebAudioEvent()

  @Serializable
  public data class AudioNodeCreatedEvent(
    public val node: AudioNode
  ) : WebAudioEvent()

  @Serializable
  public data class AudioNodeWillBeDestroyedEvent(
    public val contextId: GraphObjectId,
    public val nodeId: GraphObjectId
  ) : WebAudioEvent()

  @Serializable
  public data class AudioParamCreatedEvent(
    public val `param`: AudioParam
  ) : WebAudioEvent()

  @Serializable
  public data class AudioParamWillBeDestroyedEvent(
    public val contextId: GraphObjectId,
    public val nodeId: GraphObjectId,
    public val paramId: GraphObjectId
  ) : WebAudioEvent()

  @Serializable
  public data class NodesConnectedEvent(
    public val contextId: GraphObjectId,
    public val sourceId: GraphObjectId,
    public val destinationId: GraphObjectId,
    public val sourceOutputIndex: Double? = null,
    public val destinationInputIndex: Double? = null
  ) : WebAudioEvent()

  @Serializable
  public data class NodesDisconnectedEvent(
    public val contextId: GraphObjectId,
    public val sourceId: GraphObjectId,
    public val destinationId: GraphObjectId,
    public val sourceOutputIndex: Double? = null,
    public val destinationInputIndex: Double? = null
  ) : WebAudioEvent()

  @Serializable
  public data class NodeParamConnectedEvent(
    public val contextId: GraphObjectId,
    public val sourceId: GraphObjectId,
    public val destinationId: GraphObjectId,
    public val sourceOutputIndex: Double? = null
  ) : WebAudioEvent()

  @Serializable
  public data class NodeParamDisconnectedEvent(
    public val contextId: GraphObjectId,
    public val sourceId: GraphObjectId,
    public val destinationId: GraphObjectId,
    public val sourceOutputIndex: Double? = null
  ) : WebAudioEvent()
}
