package org.hildan.chrome.devtools.domains.webauthn

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlinx.serialization.Serializable

public typealias AuthenticatorId = String

@Serializable
public enum class AuthenticatorProtocol {
  u2f,
  ctap2,
}

@Serializable
public enum class Ctap2Version {
  ctap2_0,
  ctap2_1,
}

@Serializable
public enum class AuthenticatorTransport {
  usb,
  nfc,
  ble,
  cable,
  `internal`,
}

@Serializable
public data class VirtualAuthenticatorOptions(
  public val protocol: AuthenticatorProtocol,
  /**
   * Defaults to ctap2_0. Ignored if |protocol| == u2f.
   */
  public val ctap2Version: Ctap2Version? = null,
  public val transport: AuthenticatorTransport,
  /**
   * Defaults to false.
   */
  public val hasResidentKey: Boolean? = null,
  /**
   * Defaults to false.
   */
  public val hasUserVerification: Boolean? = null,
  /**
   * If set to true, the authenticator will support the largeBlob extension.
   * https://w3c.github.io/webauthn#largeBlob
   * Defaults to false.
   */
  public val hasLargeBlob: Boolean? = null,
  /**
   * If set to true, tests of user presence will succeed immediately.
   * Otherwise, they will not be resolved. Defaults to true.
   */
  public val automaticPresenceSimulation: Boolean? = null,
  /**
   * Sets whether User Verification succeeds or fails for an authenticator.
   * Defaults to false.
   */
  public val isUserVerified: Boolean? = null
)

@Serializable
public data class Credential(
  public val credentialId: String,
  public val isResidentCredential: Boolean,
  /**
   * Relying Party ID the credential is scoped to. Must be set when adding a
   * credential.
   */
  public val rpId: String? = null,
  /**
   * The ECDSA P-256 private key in PKCS#8 format.
   */
  public val privateKey: String,
  /**
   * An opaque byte sequence with a maximum size of 64 bytes mapping the
   * credential to a specific user.
   */
  public val userHandle: String? = null,
  /**
   * Signature counter. This is incremented by one for each successful
   * assertion.
   * See https://w3c.github.io/webauthn/#signature-counter
   */
  public val signCount: Int,
  /**
   * The large blob associated with the credential.
   * See https://w3c.github.io/webauthn/#sctn-large-blob-extension
   */
  public val largeBlob: String? = null
)
