package org.hildan.chrome.devtools.domains.console.events

import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.console.ConsoleMessage

@Serializable
public sealed class ConsoleEvent {
  /**
   * Issued when new console message is added.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#event-messageAdded)
   */
  @Serializable
  public data class MessageAddedEvent(
    /**
     * Console message that has been added.
     */
    public val message: ConsoleMessage
  ) : ConsoleEvent()
}
