package org.hildan.chrome.devtools.domains.tracing

import kotlin.Boolean
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable
import kotlinx.serialization.json.JsonElement

/**
 * Configuration for memory dump. Used only when "memory-infra" category is enabled.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Tracing/#type-MemoryDumpConfig)
 */
public typealias MemoryDumpConfig = JsonElement

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Tracing/#type-TraceConfig)
 */
@Serializable
public data class TraceConfig(
  /**
   * Controls how the trace buffer stores data.
   */
  public val recordMode: String? = null,
  /**
   * Turns on JavaScript stack sampling.
   */
  public val enableSampling: Boolean? = null,
  /**
   * Turns on system tracing.
   */
  public val enableSystrace: Boolean? = null,
  /**
   * Turns on argument filter.
   */
  public val enableArgumentFilter: Boolean? = null,
  /**
   * Included category filters.
   */
  public val includedCategories: List<String>? = null,
  /**
   * Excluded category filters.
   */
  public val excludedCategories: List<String>? = null,
  /**
   * Configuration to synthesize the delays in tracing.
   */
  public val syntheticDelays: List<String>? = null,
  /**
   * Configuration for memory dump triggers. Used only when "memory-infra" category is enabled.
   */
  public val memoryDumpConfig: MemoryDumpConfig? = null
)

/**
 * Data format of a trace. Can be either the legacy JSON format or the
 * protocol buffer format. Note that the JSON format will be deprecated soon.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Tracing/#type-StreamFormat)
 */
@Serializable
public enum class StreamFormat {
  json,
  proto,
}

/**
 * Compression type to use for traces returned via streams.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Tracing/#type-StreamCompression)
 */
@Serializable
public enum class StreamCompression {
  none,
  gzip,
}
