package org.hildan.chrome.devtools.domains.animation.events

import kotlin.String
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.animation.Animation

@Serializable
public sealed class AnimationEvent {
  /**
   * Event for when an animation has been cancelled.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#event-animationCanceled)
   */
  @Serializable
  public data class AnimationCanceledEvent(
    /**
     * Id of the animation that was cancelled.
     */
    public val id: String
  ) : AnimationEvent()

  /**
   * Event for each animation that has been created.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#event-animationCreated)
   */
  @Serializable
  public data class AnimationCreatedEvent(
    /**
     * Id of the animation that was created.
     */
    public val id: String
  ) : AnimationEvent()

  /**
   * Event for animation that has been started.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Animation/#event-animationStarted)
   */
  @Serializable
  public data class AnimationStartedEvent(
    /**
     * Animation that was started.
     */
    public val animation: Animation
  ) : AnimationEvent()
}
