package org.hildan.chrome.devtools.domains.performance

import kotlin.Double
import kotlin.String
import kotlinx.serialization.Serializable

/**
 * Run-time execution metric.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Performance/#type-Metric)
 */
@Serializable
public data class Metric(
  /**
   * Metric name.
   */
  public val name: String,
  /**
   * Metric value.
   */
  public val value: Double
)
