package org.hildan.chrome.devtools.domains.schema

import kotlin.String
import kotlinx.serialization.Serializable

/**
 * Description of the protocol domain.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Schema/#type-Domain)
 */
@Serializable
public data class Domain(
  /**
   * Domain name.
   */
  public val name: String,
  /**
   * Domain version.
   */
  public val version: String
)
