package org.hildan.chrome.devtools.domains.log.events

import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.log.LogEntry

@Serializable
public sealed class LogEvent {
  /**
   * Issued when new message was logged.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Log/#event-entryAdded)
   */
  @Serializable
  public data class EntryAddedEvent(
    /**
     * The entry.
     */
    public val entry: LogEntry
  ) : LogEvent()
}
