package org.hildan.chrome.devtools.domains.domstorage

import kotlin.Boolean
import kotlin.String
import kotlin.collections.List
import kotlinx.serialization.Serializable

/**
 * DOM Storage identifier.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMStorage/#type-StorageId)
 */
@Serializable
public data class StorageId(
  /**
   * Security origin for the storage.
   */
  public val securityOrigin: String,
  /**
   * Whether the storage is local storage (not session storage).
   */
  public val isLocalStorage: Boolean
)

/**
 * DOM Storage item.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMStorage/#type-Item)
 */
public typealias Item = List<String>
