@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.applicationcache.events

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.page.FrameId

@Serializable
public sealed class ApplicationCacheEvent {
  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#event-applicationCacheStatusUpdated)
   */
  @Serializable
  public data class ApplicationCacheStatusUpdatedEvent(
    /**
     * Identifier of the frame containing document whose application cache updated status.
     */
    public val frameId: FrameId,
    /**
     * Manifest URL.
     */
    public val manifestURL: String,
    /**
     * Updated application cache status.
     */
    public val status: Int
  ) : ApplicationCacheEvent()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#event-networkStateUpdated)
   */
  @Serializable
  public data class NetworkStateUpdatedEvent(
    public val isNowOnline: Boolean
  ) : ApplicationCacheEvent()
}
