@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.console

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlinx.serialization.Serializable

/**
 * Console message.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#type-ConsoleMessage)
 */
@Serializable
public data class ConsoleMessage(
  /**
   * Message source.
   */
  public val source: String,
  /**
   * Message severity.
   */
  public val level: String,
  /**
   * Message text.
   */
  public val text: String,
  /**
   * URL of the message origin.
   */
  public val url: String? = null,
  /**
   * Line number in the resource that generated this message (1-based).
   */
  public val line: Int? = null,
  /**
   * Column number in the resource that generated this message (1-based).
   */
  public val column: Int? = null
)
