@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.targets

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import org.hildan.chrome.devtools.domains.inspector.InspectorDomain
import org.hildan.chrome.devtools.domains.io.IODomain
import org.hildan.chrome.devtools.domains.network.NetworkDomain
import org.hildan.chrome.devtools.domains.schema.SchemaDomain
import org.hildan.chrome.devtools.domains.target.TargetDomain
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 * Represents the available domain APIs in SharedWorker targets
 */
public interface SharedWorkerTarget {
  /**
   * Input/Output operations for streams produced by DevTools.
   */
  public val io: IODomain

  @ExperimentalChromeApi
  public val inspector: InspectorDomain

  /**
   * Network domain allows tracking network activities of the page. It exposes information about
   * http,
   * file, data and other requests and responses, their headers, bodies, timing, etc.
   */
  public val network: NetworkDomain

  /**
   * Supports additional targets discovery and allows to attach to them.
   */
  public val target: TargetDomain

  /**
   * This domain is deprecated.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public val schema: SchemaDomain

  public companion object {
    internal val supportedDomains: List<String> = listOf("IO", "Inspector", "Network", "Target",
        "Schema")
  }
}
