@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.applicationcache

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.page.FrameId

/**
 * Detailed application cache resource information.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#type-ApplicationCacheResource)
 */
@Serializable
public data class ApplicationCacheResource(
  /**
   * Resource url.
   */
  public val url: String,
  /**
   * Resource size.
   */
  public val size: Int,
  /**
   * Resource type.
   */
  public val type: String
)

/**
 * Detailed application cache information.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#type-ApplicationCache)
 */
@Serializable
public data class ApplicationCache(
  /**
   * Manifest URL.
   */
  public val manifestURL: String,
  /**
   * Application cache size.
   */
  public val size: Double,
  /**
   * Application cache creation time.
   */
  public val creationTime: Double,
  /**
   * Application cache update time.
   */
  public val updateTime: Double,
  /**
   * Application cache resources.
   */
  public val resources: List<ApplicationCacheResource>
)

/**
 * Frame identifier - manifest URL pair.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ApplicationCache/#type-FrameWithManifest)
 */
@Serializable
public data class FrameWithManifest(
  /**
   * Frame identifier.
   */
  public val frameId: FrameId,
  /**
   * Manifest URL.
   */
  public val manifestURL: String,
  /**
   * Application cache status.
   */
  public val status: Int
)
