@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.domsnapshot

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.protocol.ChromeDPSession
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 * Request object containing input parameters for the [DOMSnapshotDomain.getSnapshot] command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
public data class GetSnapshotRequest(
  /**
   * Whitelist of computed styles to return.
   */
  public val computedStyleWhitelist: List<String>,
  /**
   * Whether or not to retrieve details of DOM listeners (default false).
   */
  public val includeEventListeners: Boolean? = null,
  /**
   * Whether to determine and include the paint order index of LayoutTreeNodes (default false).
   */
  public val includePaintOrder: Boolean? = null,
  /**
   * Whether to include UA shadow tree in the snapshot (default false).
   */
  public val includeUserAgentShadowTree: Boolean? = null
)

/**
 * Response type for the [DOMSnapshotDomain.getSnapshot] command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
public data class GetSnapshotResponse(
  /**
   * The nodes in the DOM tree. The DOMNode at index 0 corresponds to the root document.
   */
  public val domNodes: List<DOMNode>,
  /**
   * The nodes in the layout tree.
   */
  public val layoutTreeNodes: List<LayoutTreeNode>,
  /**
   * Whitelisted ComputedStyle properties for each node in the layout tree.
   */
  public val computedStyles: List<ComputedStyle>
)

/**
 * Request object containing input parameters for the [DOMSnapshotDomain.captureSnapshot] command.
 */
@Serializable
public data class CaptureSnapshotRequest(
  /**
   * Whitelist of computed styles to return.
   */
  public val computedStyles: List<String>,
  /**
   * Whether to include layout object paint orders into the snapshot.
   */
  public val includePaintOrder: Boolean? = null,
  /**
   * Whether to include DOM rectangles (offsetRects, clientRects, scrollRects) into the snapshot
   */
  public val includeDOMRects: Boolean? = null
)

/**
 * Response type for the [DOMSnapshotDomain.captureSnapshot] command.
 */
@Serializable
public data class CaptureSnapshotResponse(
  /**
   * The nodes in the DOM tree. The DOMNode at index 0 corresponds to the root document.
   */
  public val documents: List<DocumentSnapshot>,
  /**
   * Shared string table that all string properties refer to with indexes.
   */
  public val strings: List<String>
)

/**
 * This domain facilitates obtaining document snapshots with DOM, layout, and style information.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMSnapshot)
 */
@ExperimentalChromeApi
public class DOMSnapshotDomain internal constructor(
  private val session: ChromeDPSession
) {
  /**
   * Disables DOM snapshot agent for the given page.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMSnapshot/#method-disable)
   */
  public suspend fun disable(): Unit = session.request("DOMSnapshot.disable", Unit)

  /**
   * Enables DOM snapshot agent for the given page.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMSnapshot/#method-enable)
   */
  public suspend fun enable(): Unit = session.request("DOMSnapshot.enable", Unit)

  /**
   * Returns a document snapshot, including the full DOM tree of the root node (including iframes,
   * template contents, and imported documents) in a flattened array, as well as layout and
   * white-listed computed style information for the nodes. Shadow DOM in the returned DOM tree is
   * flattened.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMSnapshot/#method-getSnapshot)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public suspend fun getSnapshot(input: GetSnapshotRequest): GetSnapshotResponse =
      session.request("DOMSnapshot.getSnapshot", input)

  /**
   * Returns a document snapshot, including the full DOM tree of the root node (including iframes,
   * template contents, and imported documents) in a flattened array, as well as layout and
   * white-listed computed style information for the nodes. Shadow DOM in the returned DOM tree is
   * flattened.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMSnapshot/#method-captureSnapshot)
   */
  public suspend fun captureSnapshot(input: CaptureSnapshotRequest): CaptureSnapshotResponse =
      session.request("DOMSnapshot.captureSnapshot", input)
}
