@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.headlessexperimental.events

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Suppress
import kotlinx.serialization.Serializable

@Serializable
public sealed class HeadlessExperimentalEvent {
  /**
   * Issued when the target starts or stops needing BeginFrames.
   * Deprecated. Issue beginFrame unconditionally instead and use result from
   * beginFrame to detect whether the frames were suppressed.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeadlessExperimental/#event-needsBeginFramesChanged)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @Serializable
  public data class NeedsBeginFramesChangedEvent(
    /**
     * True if BeginFrames are needed, false otherwise.
     */
    public val needsBeginFrames: Boolean
  ) : HeadlessExperimentalEvent()
}
