@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.tethering.events

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlinx.serialization.Serializable

@Serializable
public sealed class TetheringEvent {
  /**
   * Informs that port was successfully bound and got a specified connection id.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Tethering/#event-accepted)
   */
  @Serializable
  public data class AcceptedEvent(
    /**
     * Port number that was successfully bound.
     */
    public val port: Int,
    /**
     * Connection id to be used.
     */
    public val connectionId: String
  ) : TetheringEvent()
}
