@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.accessibility.events

import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.accessibility.AXNode
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

@Serializable
public sealed class AccessibilityEvent {
  /**
   * The loadComplete event mirrors the load complete event sent by the browser to assistive
   * technology when the web page has finished loading.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#event-loadComplete)
   */
  @ExperimentalChromeApi
  @Serializable
  public data class LoadComplete(
    /**
     * New document root node.
     */
    public val root: AXNode,
  ) : AccessibilityEvent()

  /**
   * The nodesUpdated event is sent every time a previously requested node has changed the in tree.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Accessibility/#event-nodesUpdated)
   */
  @ExperimentalChromeApi
  @Serializable
  public data class NodesUpdated(
    /**
     * Updated node data.
     */
    public val nodes: List<AXNode>,
  ) : AccessibilityEvent()
}
