@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.audits.events

import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.audits.InspectorIssue

@Serializable
public sealed class AuditsEvent {
  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Audits/#event-issueAdded)
   */
  @Serializable
  public data class IssueAdded(
    public val issue: InspectorIssue,
  ) : AuditsEvent()
}
