@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.browser.events

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.browser.DownloadProgressState
import org.hildan.chrome.devtools.domains.page.FrameId
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

@Serializable
public sealed class BrowserEvent {
  /**
   * Fired when page is about to start a download.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Browser/#event-downloadWillBegin)
   */
  @ExperimentalChromeApi
  @Serializable
  public data class DownloadWillBegin(
    /**
     * Id of the frame that caused the download to begin.
     */
    public val frameId: FrameId,
    /**
     * Global unique identifier of the download.
     */
    public val guid: String,
    /**
     * URL of the resource being downloaded.
     */
    public val url: String,
    /**
     * Suggested file name of the resource (the actual name of the file saved on disk may differ).
     */
    public val suggestedFilename: String,
  ) : BrowserEvent()

  /**
   * Fired when download makes progress. Last call has |done| == true.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Browser/#event-downloadProgress)
   */
  @ExperimentalChromeApi
  @Serializable
  public data class DownloadProgress(
    /**
     * Global unique identifier of the download.
     */
    public val guid: String,
    /**
     * Total expected bytes to download.
     */
    public val totalBytes: Double,
    /**
     * Total bytes received.
     */
    public val receivedBytes: Double,
    /**
     * Download status.
     */
    public val state: DownloadProgressState,
  ) : BrowserEvent()
}
