@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.cast.events

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.cast.Sink

@Serializable
public sealed class CastEvent {
  /**
   * This is fired whenever the list of available sinks changes. A sink is a
   * device or a software surface that you can cast to.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Cast/#event-sinksUpdated)
   */
  @Serializable
  public data class SinksUpdated(
    public val sinks: List<Sink>,
  ) : CastEvent()

  /**
   * This is fired whenever the outstanding issue/error message changes.
   * |issueMessage| is empty if there is no issue.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Cast/#event-issueUpdated)
   */
  @Serializable
  public data class IssueUpdated(
    public val issueMessage: String,
  ) : CastEvent()
}
