@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.console

import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlinx.coroutines.flow.Flow
import kotlinx.serialization.DeserializationStrategy
import kotlinx.serialization.Serializable
import kotlinx.serialization.serializer
import org.hildan.chrome.devtools.domains.console.events.ConsoleEvent
import org.hildan.chrome.devtools.protocol.ChromeDPSession
import org.hildan.chrome.devtools.protocol.request
import org.hildan.chrome.devtools.protocol.typedEvents

/**
 * A dummy response object for the [ConsoleDomain.clearMessages] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
public object ClearMessagesResponse

/**
 * A dummy response object for the [ConsoleDomain.disable] command. This command doesn't return any
 * result at the moment, but this could happen in the future, or could have happened in the past. For
 * forwards and backwards compatibility of the command method, we still declare this class even without
 * properties.
 */
@Serializable
public object DisableResponse

/**
 * A dummy response object for the [ConsoleDomain.enable] command. This command doesn't return any
 * result at the moment, but this could happen in the future, or could have happened in the past. For
 * forwards and backwards compatibility of the command method, we still declare this class even without
 * properties.
 */
@Serializable
public object EnableResponse

/**
 * This domain is deprecated - use Runtime or Log instead.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console)
 */
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
public class ConsoleDomain internal constructor(
  private val session: ChromeDPSession,
) {
  /**
   * Mapping between events and their deserializer.
   */
  private val deserializersByEventName: Map<String, DeserializationStrategy<out ConsoleEvent>> =
      mapOf(
      "Console.messageAdded" to serializer<ConsoleEvent.MessageAdded>(),
      )

  /**
   * Subscribes to all events related to this domain.
   */
  public fun events(): Flow<ConsoleEvent> = session.typedEvents(deserializersByEventName)

  /**
   * Issued when new console message is added.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#event-messageAdded)
   */
  public fun messageAddedEvents(): Flow<ConsoleEvent.MessageAdded> =
      session.typedEvents("Console.messageAdded")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("messageAddedEvents()"),
  )
  public fun messageAdded(): Flow<ConsoleEvent.MessageAdded> = messageAddedEvents()

  /**
   * Does nothing.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#method-clearMessages)
   */
  public suspend fun clearMessages(): ClearMessagesResponse =
      session.request("Console.clearMessages", Unit)

  /**
   * Disables console domain, prevents further console messages from being reported to the client.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#method-disable)
   */
  public suspend fun disable(): DisableResponse = session.request("Console.disable", Unit)

  /**
   * Enables console domain, sends the messages collected so far to the client by means of the
   * `messageAdded` notification.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#method-enable)
   */
  public suspend fun enable(): EnableResponse = session.request("Console.enable", Unit)
}
