@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.console

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlinx.serialization.Serializable

/**
 * Console message.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#type-ConsoleMessage)
 */
@Serializable
public data class ConsoleMessage(
  /**
   * Message source.
   */
  public val source: ConsoleMessageSource,
  /**
   * Message severity.
   */
  public val level: ConsoleMessageLevel,
  /**
   * Message text.
   */
  public val text: String,
  /**
   * URL of the message origin.
   */
  public val url: String? = null,
  /**
   * Line number in the resource that generated this message (1-based).
   */
  public val line: Int? = null,
  /**
   * Column number in the resource that generated this message (1-based).
   */
  public val column: Int? = null,
)

/**
 * This enum doesn't have a proper description because it was generated from an inline declaration.
 * Its name was inferred based on the place where it is used:
 *  - the property 'source' of the type 'ConsoleMessage'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#type-ConsoleMessageSource)
 */
@Serializable
public enum class ConsoleMessageSource {
  xml,
  javascript,
  network,
  `console-api`,
  storage,
  appcache,
  rendering,
  security,
  other,
  deprecation,
  worker,
}

/**
 * This enum doesn't have a proper description because it was generated from an inline declaration.
 * Its name was inferred based on the place where it is used:
 *  - the property 'level' of the type 'ConsoleMessage'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Console/#type-ConsoleMessageLevel)
 */
@Serializable
public enum class ConsoleMessageLevel {
  log,
  warning,
  error,
  debug,
  info,
}
