@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.deviceorientation

import kotlin.Double
import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.protocol.ChromeDPSession
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi
import org.hildan.chrome.devtools.protocol.request

/**
 * A dummy response object for the [DeviceOrientationDomain.clearDeviceOrientationOverride] command.
 * This command doesn't return any result at the moment, but this could happen in the future, or could
 * have happened in the past. For forwards and backwards compatibility of the command method, we still
 * declare this class even without properties.
 */
@Serializable
public object ClearDeviceOrientationOverrideResponse

/**
 * Request object containing input parameters for the
 * [DeviceOrientationDomain.setDeviceOrientationOverride] command.
 */
@Serializable
public data class SetDeviceOrientationOverrideRequest(
  /**
   * Mock alpha
   */
  public val alpha: Double,
  /**
   * Mock beta
   */
  public val beta: Double,
  /**
   * Mock gamma
   */
  public val gamma: Double,
)

/**
 * A dummy response object for the [DeviceOrientationDomain.setDeviceOrientationOverride] command.
 * This command doesn't return any result at the moment, but this could happen in the future, or could
 * have happened in the past. For forwards and backwards compatibility of the command method, we still
 * declare this class even without properties.
 */
@Serializable
public object SetDeviceOrientationOverrideResponse

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DeviceOrientation)
 */
@ExperimentalChromeApi
public class DeviceOrientationDomain internal constructor(
  private val session: ChromeDPSession,
) {
  /**
   * Clears the overridden Device Orientation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DeviceOrientation/#method-clearDeviceOrientationOverride)
   */
  public suspend fun clearDeviceOrientationOverride(): ClearDeviceOrientationOverrideResponse =
      session.request("DeviceOrientation.clearDeviceOrientationOverride", Unit)

  /**
   * Overrides the Device Orientation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DeviceOrientation/#method-setDeviceOrientationOverride)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun setDeviceOrientationOverride(input: SetDeviceOrientationOverrideRequest):
      SetDeviceOrientationOverrideResponse =
      session.request("DeviceOrientation.setDeviceOrientationOverride", input)

  /**
   * Overrides the Device Orientation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DeviceOrientation/#method-setDeviceOrientationOverride)
   *
   * @param alpha Mock alpha
   * @param beta Mock beta
   * @param gamma Mock gamma
   */
  public suspend fun setDeviceOrientationOverride(
    alpha: Double,
    beta: Double,
    gamma: Double,
  ): SetDeviceOrientationOverrideResponse {
    val input = SetDeviceOrientationOverrideRequest(alpha, beta, gamma)
    return setDeviceOrientationOverride(input)
  }
}
