@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.domsnapshot

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmOverloads
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.protocol.ChromeDPSession
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi
import org.hildan.chrome.devtools.protocol.request

/**
 * A dummy response object for the [DOMSnapshotDomain.disable] command. This command doesn't return
 * any result at the moment, but this could happen in the future, or could have happened in the past.
 * For forwards and backwards compatibility of the command method, we still declare this class even
 * without properties.
 */
@Serializable
public object DisableResponse

/**
 * A dummy response object for the [DOMSnapshotDomain.enable] command. This command doesn't return
 * any result at the moment, but this could happen in the future, or could have happened in the past.
 * For forwards and backwards compatibility of the command method, we still declare this class even
 * without properties.
 */
@Serializable
public object EnableResponse

/**
 * Request object containing input parameters for the [DOMSnapshotDomain.getSnapshot] command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
public data class GetSnapshotRequest(
  /**
   * Whitelist of computed styles to return.
   */
  public val computedStyleWhitelist: List<String>,
  /**
   * Whether or not to retrieve details of DOM listeners (default false).
   */
  public val includeEventListeners: Boolean? = null,
  /**
   * Whether to determine and include the paint order index of LayoutTreeNodes (default false).
   */
  public val includePaintOrder: Boolean? = null,
  /**
   * Whether to include UA shadow tree in the snapshot (default false).
   */
  public val includeUserAgentShadowTree: Boolean? = null,
) {
  public class Builder(
    /**
     * Whitelist of computed styles to return.
     */
    public val computedStyleWhitelist: List<String>,
  ) {
    /**
     * Whether or not to retrieve details of DOM listeners (default false).
     */
    public var includeEventListeners: Boolean? = null

    /**
     * Whether to determine and include the paint order index of LayoutTreeNodes (default false).
     */
    public var includePaintOrder: Boolean? = null

    /**
     * Whether to include UA shadow tree in the snapshot (default false).
     */
    public var includeUserAgentShadowTree: Boolean? = null

    public fun build(): GetSnapshotRequest = GetSnapshotRequest(computedStyleWhitelist,
        includeEventListeners, includePaintOrder, includeUserAgentShadowTree)
  }
}

/**
 * Response type for the [DOMSnapshotDomain.getSnapshot] command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
public data class GetSnapshotResponse(
  /**
   * The nodes in the DOM tree. The DOMNode at index 0 corresponds to the root document.
   */
  public val domNodes: List<DOMNode>,
  /**
   * The nodes in the layout tree.
   */
  public val layoutTreeNodes: List<LayoutTreeNode>,
  /**
   * Whitelisted ComputedStyle properties for each node in the layout tree.
   */
  public val computedStyles: List<ComputedStyle>,
)

/**
 * Request object containing input parameters for the [DOMSnapshotDomain.captureSnapshot] command.
 */
@Serializable
public data class CaptureSnapshotRequest(
  /**
   * Whitelist of computed styles to return.
   */
  public val computedStyles: List<String>,
  /**
   * Whether to include layout object paint orders into the snapshot.
   */
  public val includePaintOrder: Boolean? = null,
  /**
   * Whether to include DOM rectangles (offsetRects, clientRects, scrollRects) into the snapshot
   */
  public val includeDOMRects: Boolean? = null,
  /**
   * Whether to include blended background colors in the snapshot (default: false).
   * Blended background color is achieved by blending background colors of all elements
   * that overlap with the current element.
   */
  @ExperimentalChromeApi
  public val includeBlendedBackgroundColors: Boolean? = null,
  /**
   * Whether to include text color opacity in the snapshot (default: false).
   * An element might have the opacity property set that affects the text color of the element.
   * The final text color opacity is computed based on the opacity of all overlapping elements.
   */
  @ExperimentalChromeApi
  public val includeTextColorOpacities: Boolean? = null,
) {
  public class Builder(
    /**
     * Whitelist of computed styles to return.
     */
    public val computedStyles: List<String>,
  ) {
    /**
     * Whether to include layout object paint orders into the snapshot.
     */
    public var includePaintOrder: Boolean? = null

    /**
     * Whether to include DOM rectangles (offsetRects, clientRects, scrollRects) into the snapshot
     */
    public var includeDOMRects: Boolean? = null

    /**
     * Whether to include blended background colors in the snapshot (default: false).
     * Blended background color is achieved by blending background colors of all elements
     * that overlap with the current element.
     */
    @ExperimentalChromeApi
    public var includeBlendedBackgroundColors: Boolean? = null

    /**
     * Whether to include text color opacity in the snapshot (default: false).
     * An element might have the opacity property set that affects the text color of the element.
     * The final text color opacity is computed based on the opacity of all overlapping elements.
     */
    @ExperimentalChromeApi
    public var includeTextColorOpacities: Boolean? = null

    public fun build(): CaptureSnapshotRequest = CaptureSnapshotRequest(computedStyles,
        includePaintOrder, includeDOMRects, includeBlendedBackgroundColors,
        includeTextColorOpacities)
  }
}

/**
 * Response type for the [DOMSnapshotDomain.captureSnapshot] command.
 */
@Serializable
public data class CaptureSnapshotResponse(
  /**
   * The nodes in the DOM tree. The DOMNode at index 0 corresponds to the root document.
   */
  public val documents: List<DocumentSnapshot>,
  /**
   * Shared string table that all string properties refer to with indexes.
   */
  public val strings: List<String>,
)

/**
 * This domain facilitates obtaining document snapshots with DOM, layout, and style information.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMSnapshot)
 */
@ExperimentalChromeApi
public class DOMSnapshotDomain internal constructor(
  private val session: ChromeDPSession,
) {
  /**
   * Disables DOM snapshot agent for the given page.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMSnapshot/#method-disable)
   */
  public suspend fun disable(): DisableResponse = session.request("DOMSnapshot.disable", Unit)

  /**
   * Enables DOM snapshot agent for the given page.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMSnapshot/#method-enable)
   */
  public suspend fun enable(): EnableResponse = session.request("DOMSnapshot.enable", Unit)

  /**
   * Returns a document snapshot, including the full DOM tree of the root node (including iframes,
   * template contents, and imported documents) in a flattened array, as well as layout and
   * white-listed computed style information for the nodes. Shadow DOM in the returned DOM tree is
   * flattened.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMSnapshot/#method-getSnapshot)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public suspend fun getSnapshot(input: GetSnapshotRequest): GetSnapshotResponse =
      session.request("DOMSnapshot.getSnapshot", input)

  /**
   * Returns a document snapshot, including the full DOM tree of the root node (including iframes,
   * template contents, and imported documents) in a flattened array, as well as layout and
   * white-listed computed style information for the nodes. Shadow DOM in the returned DOM tree is
   * flattened.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMSnapshot/#method-getSnapshot)
   *
   * @param computedStyleWhitelist Whitelist of computed styles to return.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @JvmOverloads
  public suspend inline fun getSnapshot(computedStyleWhitelist: List<String>,
      optionalArgs: GetSnapshotRequest.Builder.() -> Unit = {}): GetSnapshotResponse {
    val builder = GetSnapshotRequest.Builder(computedStyleWhitelist)
    val input = builder.apply(optionalArgs).build()
    return getSnapshot(input)
  }

  /**
   * Returns a document snapshot, including the full DOM tree of the root node (including iframes,
   * template contents, and imported documents) in a flattened array, as well as layout and
   * white-listed computed style information for the nodes. Shadow DOM in the returned DOM tree is
   * flattened.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMSnapshot/#method-captureSnapshot)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun captureSnapshot(input: CaptureSnapshotRequest): CaptureSnapshotResponse =
      session.request("DOMSnapshot.captureSnapshot", input)

  /**
   * Returns a document snapshot, including the full DOM tree of the root node (including iframes,
   * template contents, and imported documents) in a flattened array, as well as layout and
   * white-listed computed style information for the nodes. Shadow DOM in the returned DOM tree is
   * flattened.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/DOMSnapshot/#method-captureSnapshot)
   *
   * @param computedStyles Whitelist of computed styles to return.
   */
  @JvmOverloads
  public suspend inline fun captureSnapshot(computedStyles: List<String>,
      optionalArgs: CaptureSnapshotRequest.Builder.() -> Unit = {}): CaptureSnapshotResponse {
    val builder = CaptureSnapshotRequest.Builder(computedStyles)
    val input = builder.apply(optionalArgs).build()
    return captureSnapshot(input)
  }
}
