@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.emulation

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

/**
 * Screen orientation.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Emulation/#type-ScreenOrientation)
 */
@Serializable
public data class ScreenOrientation(
  /**
   * Orientation type.
   */
  public val type: ScreenOrientationType,
  /**
   * Orientation angle.
   */
  public val angle: Int,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Emulation/#type-DisplayFeature)
 */
@Serializable
public data class DisplayFeature(
  /**
   * Orientation of a display feature in relation to screen
   */
  public val orientation: DisplayFeatureOrientation,
  /**
   * The offset from the screen origin in either the x (for vertical
   * orientation) or y (for horizontal orientation) direction.
   */
  public val offset: Int,
  /**
   * A display feature may mask content such that it is not physically
   * displayed - this length along with the offset describes this area.
   * A display feature that only splits content will have a 0 mask_length.
   */
  public val maskLength: Int,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Emulation/#type-MediaFeature)
 */
@Serializable
public data class MediaFeature(
  public val name: String,
  public val `value`: String,
)

/**
 * advance: If the scheduler runs out of immediate work, the virtual time base may fast forward to
 * allow the next delayed task (if any) to run; pause: The virtual time base may not advance;
 * pauseIfNetworkFetchesPending: The virtual time base may not advance if there are any pending
 * resource fetches.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Emulation/#type-VirtualTimePolicy)
 */
@ExperimentalChromeApi
@Serializable
public enum class VirtualTimePolicy {
  advance,
  pause,
  pauseIfNetworkFetchesPending,
}

/**
 * Used to specify User Agent Cient Hints to emulate. See https://wicg.github.io/ua-client-hints
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Emulation/#type-UserAgentBrandVersion)
 */
@ExperimentalChromeApi
@Serializable
public data class UserAgentBrandVersion(
  public val brand: String,
  public val version: String,
)

/**
 * Used to specify User Agent Cient Hints to emulate. See https://wicg.github.io/ua-client-hints
 * Missing optional values will be filled in by the target with what it would normally use.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Emulation/#type-UserAgentMetadata)
 */
@ExperimentalChromeApi
@Serializable
public data class UserAgentMetadata(
  public val brands: List<UserAgentBrandVersion>? = null,
  public val fullVersionList: List<UserAgentBrandVersion>? = null,
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public val fullVersion: String? = null,
  public val platform: String,
  public val platformVersion: String,
  public val architecture: String,
  public val model: String,
  public val mobile: Boolean,
  public val bitness: String? = null,
  public val wow64: Boolean? = null,
)

/**
 * Enum of image types that can be disabled.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Emulation/#type-DisabledImageType)
 */
@ExperimentalChromeApi
@Serializable
public enum class DisabledImageType {
  avif,
  jxl,
  webp,
}

/**
 * This enum doesn't have a proper description because it was generated from an inline declaration.
 * Its name was inferred based on the place where it is used:
 *  - the property 'type' of the type 'ScreenOrientation'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Emulation/#type-ScreenOrientationType)
 */
@Serializable
public enum class ScreenOrientationType {
  portraitPrimary,
  portraitSecondary,
  landscapePrimary,
  landscapeSecondary,
}

/**
 * This enum doesn't have a proper description because it was generated from an inline declaration.
 * Its name was inferred based on the place where it is used:
 *  - the property 'orientation' of the type 'DisplayFeature'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Emulation/#type-DisplayFeatureOrientation)
 */
@Serializable
public enum class DisplayFeatureOrientation {
  vertical,
  horizontal,
}

/**
 * This enum doesn't have a proper description because it was generated from an inline declaration.
 * Its name was inferred based on the place where it is used:
 *  - the parameter 'configuration' of the command 'Emulation.setEmitTouchEventsForMouse'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Emulation/#type-TouchEventsConfiguration)
 */
@Serializable
public enum class TouchEventsConfiguration {
  mobile,
  desktop,
}

/**
 * This enum doesn't have a proper description because it was generated from an inline declaration.
 * Its name was inferred based on the place where it is used:
 *  - the parameter 'type' of the command 'Emulation.setEmulatedVisionDeficiency'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Emulation/#type-EmulatedVisionDeficiencyType)
 */
@Serializable
public enum class EmulatedVisionDeficiencyType {
  none,
  achromatopsia,
  blurredVision,
  deuteranopia,
  protanopia,
  tritanopia,
}
