@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.headlessexperimental

import kotlin.Boolean
import kotlin.Int
import kotlin.Suppress
import kotlinx.serialization.Serializable

/**
 * Encoding options for a screenshot.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeadlessExperimental/#type-ScreenshotParams)
 */
@Serializable
public data class ScreenshotParams(
  /**
   * Image compression format (defaults to png).
   */
  public val format: ImageFormat? = null,
  /**
   * Compression quality from range [0..100] (jpeg only).
   */
  public val quality: Int? = null,
  /**
   * Optimize image encoding for speed, not for resulting size (defaults to false)
   */
  public val optimizeForSpeed: Boolean? = null,
)

/**
 * This enum doesn't have a proper description because it was generated from an inline declaration.
 * Its name was inferred based on the place where it is used:
 *  - the property 'format' of the type 'ScreenshotParams'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeadlessExperimental/#type-ImageFormat)
 */
@Serializable
public enum class ImageFormat {
  jpeg,
  png,
  webp,
}
