@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.heapprofiler

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.runtime.CallFrame

/**
 * Heap snapshot object id.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#type-HeapSnapshotObjectId)
 */
public typealias HeapSnapshotObjectId = String

/**
 * Sampling Heap Profile node. Holds callsite information, allocation statistics and child nodes.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#type-SamplingHeapProfileNode)
 */
@Serializable
public data class SamplingHeapProfileNode(
  /**
   * Function location.
   */
  public val callFrame: CallFrame,
  /**
   * Allocations size in bytes for the node excluding children.
   */
  public val selfSize: Double,
  /**
   * Node id. Ids are unique across all profiles collected between startSampling and stopSampling.
   */
  public val id: Int,
  /**
   * Child nodes.
   */
  public val children: List<SamplingHeapProfileNode>,
)

/**
 * A single sample from a sampling profile.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#type-SamplingHeapProfileSample)
 */
@Serializable
public data class SamplingHeapProfileSample(
  /**
   * Allocation size in bytes attributed to the sample.
   */
  public val size: Double,
  /**
   * Id of the corresponding profile tree node.
   */
  public val nodeId: Int,
  /**
   * Time-ordered sample ordinal number. It is unique across all profiles retrieved
   * between startSampling and stopSampling.
   */
  public val ordinal: Double,
)

/**
 * Sampling profile.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#type-SamplingHeapProfile)
 */
@Serializable
public data class SamplingHeapProfile(
  public val head: SamplingHeapProfileNode,
  public val samples: List<SamplingHeapProfileSample>,
)
