@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.heapprofiler.events

import kotlin.Boolean
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable

@Serializable
public sealed class HeapProfilerEvent {
  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#event-addHeapSnapshotChunk)
   */
  @Serializable
  public data class AddHeapSnapshotChunk(
    public val chunk: String,
  ) : HeapProfilerEvent()

  /**
   * If heap objects tracking has been started then backend may send update for one or more
   * fragments
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#event-heapStatsUpdate)
   */
  @Serializable
  public data class HeapStatsUpdate(
    /**
     * An array of triplets. Each triplet describes a fragment. The first integer is the fragment
     * index, the second integer is a total count of objects for the fragment, the third integer is
     * a total size of the objects for the fragment.
     */
    public val statsUpdate: List<Int>,
  ) : HeapProfilerEvent()

  /**
   * If heap objects tracking has been started then backend regularly sends a current value for last
   * seen object id and corresponding timestamp. If the were changes in the heap since last event
   * then one or more heapStatsUpdate events will be sent before a new lastSeenObjectId event.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#event-lastSeenObjectId)
   */
  @Serializable
  public data class LastSeenObjectId(
    public val lastSeenObjectId: Int,
    public val timestamp: Double,
  ) : HeapProfilerEvent()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#event-reportHeapSnapshotProgress)
   */
  @Serializable
  public data class ReportHeapSnapshotProgress(
    public val done: Int,
    public val total: Int,
    public val finished: Boolean? = null,
  ) : HeapProfilerEvent()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/HeapProfiler/#event-resetProfiles)
   */
  @Serializable
  public object ResetProfiles : HeapProfilerEvent()
}
