@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.input.events

import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.input.DragData
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

@Serializable
public sealed class InputEvent {
  /**
   * Emitted only when `Input.setInterceptDrags` is enabled. Use this data with
   * `Input.dispatchDragEvent` to
   * restore normal drag and drop behavior.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Input/#event-dragIntercepted)
   */
  @ExperimentalChromeApi
  @Serializable
  public data class DragIntercepted(
    public val `data`: DragData,
  ) : InputEvent()
}
