@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.log

import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.network.RequestId
import org.hildan.chrome.devtools.domains.runtime.RemoteObject
import org.hildan.chrome.devtools.domains.runtime.StackTrace
import org.hildan.chrome.devtools.domains.runtime.Timestamp

/**
 * Log entry.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Log/#type-LogEntry)
 */
@Serializable
public data class LogEntry(
  /**
   * Log entry source.
   */
  public val source: LogEntrySource,
  /**
   * Log entry severity.
   */
  public val level: LogEntryLevel,
  /**
   * Logged text.
   */
  public val text: String,
  public val category: LogEntryCategory? = null,
  /**
   * Timestamp when this entry was added.
   */
  public val timestamp: Timestamp,
  /**
   * URL of the resource if known.
   */
  public val url: String? = null,
  /**
   * Line number in the resource.
   */
  public val lineNumber: Int? = null,
  /**
   * JavaScript stack trace.
   */
  public val stackTrace: StackTrace? = null,
  /**
   * Identifier of the network request associated with this entry.
   */
  public val networkRequestId: RequestId? = null,
  /**
   * Identifier of the worker associated with this entry.
   */
  public val workerId: String? = null,
  /**
   * Call arguments.
   */
  public val args: List<RemoteObject>? = null,
)

/**
 * Violation configuration setting.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Log/#type-ViolationSetting)
 */
@Serializable
public data class ViolationSetting(
  /**
   * Violation type.
   */
  public val name: ViolationSettingName,
  /**
   * Time threshold to trigger upon.
   */
  public val threshold: Double,
)

/**
 * This enum doesn't have a proper description because it was generated from an inline declaration.
 * Its name was inferred based on the place where it is used:
 *  - the property 'source' of the type 'LogEntry'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Log/#type-LogEntrySource)
 */
@Serializable
public enum class LogEntrySource {
  xml,
  javascript,
  network,
  storage,
  appcache,
  rendering,
  security,
  deprecation,
  worker,
  violation,
  intervention,
  recommendation,
  other,
}

/**
 * This enum doesn't have a proper description because it was generated from an inline declaration.
 * Its name was inferred based on the place where it is used:
 *  - the property 'level' of the type 'LogEntry'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Log/#type-LogEntryLevel)
 */
@Serializable
public enum class LogEntryLevel {
  verbose,
  info,
  warning,
  error,
}

/**
 * This enum doesn't have a proper description because it was generated from an inline declaration.
 * Its name was inferred based on the place where it is used:
 *  - the property 'category' of the type 'LogEntry'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Log/#type-LogEntryCategory)
 */
@Serializable
public enum class LogEntryCategory {
  cors,
}

/**
 * This enum doesn't have a proper description because it was generated from an inline declaration.
 * Its name was inferred based on the place where it is used:
 *  - the property 'name' of the type 'ViolationSetting'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Log/#type-ViolationSettingName)
 */
@Serializable
public enum class ViolationSettingName {
  longTask,
  longLayout,
  blockedEvent,
  blockedParser,
  discouragedAPIUse,
  handler,
  recurringHandler,
}
