@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.log.events

import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.log.LogEntry

@Serializable
public sealed class LogEvent {
  /**
   * Issued when new message was logged.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Log/#event-entryAdded)
   */
  @Serializable
  public data class EntryAdded(
    /**
     * The entry.
     */
    public val entry: LogEntry,
  ) : LogEvent()
}
