@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.memory

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable

/**
 * Memory pressure level.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Memory/#type-PressureLevel)
 */
@Serializable
public enum class PressureLevel {
  moderate,
  critical,
}

/**
 * Heap profile sample.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Memory/#type-SamplingProfileNode)
 */
@Serializable
public data class SamplingProfileNode(
  /**
   * Size of the sampled allocation.
   */
  public val size: Double,
  /**
   * Total bytes attributed to this sample.
   */
  public val total: Double,
  /**
   * Execution stack at the point of allocation.
   */
  public val stack: List<String>,
)

/**
 * Array of heap profile samples.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Memory/#type-SamplingProfile)
 */
@Serializable
public data class SamplingProfile(
  public val samples: List<SamplingProfileNode>,
  public val modules: List<Module>,
)

/**
 * Executable module information
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Memory/#type-Module)
 */
@Serializable
public data class Module(
  /**
   * Name of the module.
   */
  public val name: String,
  /**
   * UUID of the module.
   */
  public val uuid: String,
  /**
   * Base address where the module is loaded into memory. Encoded as a decimal
   * or hexadecimal (0x prefixed) string.
   */
  public val baseAddress: String,
  /**
   * Size of the module in bytes.
   */
  public val size: Double,
)
