@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.overlay

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.dom.NodeId
import org.hildan.chrome.devtools.domains.dom.RGBA
import org.hildan.chrome.devtools.domains.dom.Rect

/**
 * Configuration data for drawing the source order of an elements children.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-SourceOrderConfig)
 */
@Serializable
public data class SourceOrderConfig(
  /**
   * the color to outline the givent element in.
   */
  public val parentOutlineColor: RGBA,
  /**
   * the color to outline the child elements in.
   */
  public val childOutlineColor: RGBA,
)

/**
 * Configuration data for the highlighting of Grid elements.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-GridHighlightConfig)
 */
@Serializable
public data class GridHighlightConfig(
  /**
   * Whether the extension lines from grid cells to the rulers should be shown (default: false).
   */
  public val showGridExtensionLines: Boolean? = null,
  /**
   * Show Positive line number labels (default: false).
   */
  public val showPositiveLineNumbers: Boolean? = null,
  /**
   * Show Negative line number labels (default: false).
   */
  public val showNegativeLineNumbers: Boolean? = null,
  /**
   * Show area name labels (default: false).
   */
  public val showAreaNames: Boolean? = null,
  /**
   * Show line name labels (default: false).
   */
  public val showLineNames: Boolean? = null,
  /**
   * Show track size labels (default: false).
   */
  public val showTrackSizes: Boolean? = null,
  /**
   * The grid container border highlight color (default: transparent).
   */
  public val gridBorderColor: RGBA? = null,
  /**
   * The cell border color (default: transparent). Deprecated, please use rowLineColor and
   * columnLineColor instead.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public val cellBorderColor: RGBA? = null,
  /**
   * The row line color (default: transparent).
   */
  public val rowLineColor: RGBA? = null,
  /**
   * The column line color (default: transparent).
   */
  public val columnLineColor: RGBA? = null,
  /**
   * Whether the grid border is dashed (default: false).
   */
  public val gridBorderDash: Boolean? = null,
  /**
   * Whether the cell border is dashed (default: false). Deprecated, please us rowLineDash and
   * columnLineDash instead.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public val cellBorderDash: Boolean? = null,
  /**
   * Whether row lines are dashed (default: false).
   */
  public val rowLineDash: Boolean? = null,
  /**
   * Whether column lines are dashed (default: false).
   */
  public val columnLineDash: Boolean? = null,
  /**
   * The row gap highlight fill color (default: transparent).
   */
  public val rowGapColor: RGBA? = null,
  /**
   * The row gap hatching fill color (default: transparent).
   */
  public val rowHatchColor: RGBA? = null,
  /**
   * The column gap highlight fill color (default: transparent).
   */
  public val columnGapColor: RGBA? = null,
  /**
   * The column gap hatching fill color (default: transparent).
   */
  public val columnHatchColor: RGBA? = null,
  /**
   * The named grid areas border color (Default: transparent).
   */
  public val areaBorderColor: RGBA? = null,
  /**
   * The grid container background color (Default: transparent).
   */
  public val gridBackgroundColor: RGBA? = null,
)

/**
 * Configuration data for the highlighting of Flex container elements.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-FlexContainerHighlightConfig)
 */
@Serializable
public data class FlexContainerHighlightConfig(
  /**
   * The style of the container border
   */
  public val containerBorder: LineStyle? = null,
  /**
   * The style of the separator between lines
   */
  public val lineSeparator: LineStyle? = null,
  /**
   * The style of the separator between items
   */
  public val itemSeparator: LineStyle? = null,
  /**
   * Style of content-distribution space on the main axis (justify-content).
   */
  public val mainDistributedSpace: BoxStyle? = null,
  /**
   * Style of content-distribution space on the cross axis (align-content).
   */
  public val crossDistributedSpace: BoxStyle? = null,
  /**
   * Style of empty space caused by row gaps (gap/row-gap).
   */
  public val rowGapSpace: BoxStyle? = null,
  /**
   * Style of empty space caused by columns gaps (gap/column-gap).
   */
  public val columnGapSpace: BoxStyle? = null,
  /**
   * Style of the self-alignment line (align-items).
   */
  public val crossAlignment: LineStyle? = null,
)

/**
 * Configuration data for the highlighting of Flex item elements.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-FlexItemHighlightConfig)
 */
@Serializable
public data class FlexItemHighlightConfig(
  /**
   * Style of the box representing the item's base size
   */
  public val baseSizeBox: BoxStyle? = null,
  /**
   * Style of the border around the box representing the item's base size
   */
  public val baseSizeBorder: LineStyle? = null,
  /**
   * Style of the arrow representing if the item grew or shrank
   */
  public val flexibilityArrow: LineStyle? = null,
)

/**
 * Style information for drawing a line.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-LineStyle)
 */
@Serializable
public data class LineStyle(
  /**
   * The color of the line (default: transparent)
   */
  public val color: RGBA? = null,
  /**
   * The line pattern (default: solid)
   */
  public val pattern: LineStylePattern? = null,
)

/**
 * Style information for drawing a box.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-BoxStyle)
 */
@Serializable
public data class BoxStyle(
  /**
   * The background color for the box (default: transparent)
   */
  public val fillColor: RGBA? = null,
  /**
   * The hatching color for the box (default: transparent)
   */
  public val hatchColor: RGBA? = null,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-ContrastAlgorithm)
 */
@Serializable
public enum class ContrastAlgorithm {
  aa,
  aaa,
  apca,
}

/**
 * Configuration data for the highlighting of page elements.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-HighlightConfig)
 */
@Serializable
public data class HighlightConfig(
  /**
   * Whether the node info tooltip should be shown (default: false).
   */
  public val showInfo: Boolean? = null,
  /**
   * Whether the node styles in the tooltip (default: false).
   */
  public val showStyles: Boolean? = null,
  /**
   * Whether the rulers should be shown (default: false).
   */
  public val showRulers: Boolean? = null,
  /**
   * Whether the a11y info should be shown (default: true).
   */
  public val showAccessibilityInfo: Boolean? = null,
  /**
   * Whether the extension lines from node to the rulers should be shown (default: false).
   */
  public val showExtensionLines: Boolean? = null,
  /**
   * The content box highlight fill color (default: transparent).
   */
  public val contentColor: RGBA? = null,
  /**
   * The padding highlight fill color (default: transparent).
   */
  public val paddingColor: RGBA? = null,
  /**
   * The border highlight fill color (default: transparent).
   */
  public val borderColor: RGBA? = null,
  /**
   * The margin highlight fill color (default: transparent).
   */
  public val marginColor: RGBA? = null,
  /**
   * The event target element highlight fill color (default: transparent).
   */
  public val eventTargetColor: RGBA? = null,
  /**
   * The shape outside fill color (default: transparent).
   */
  public val shapeColor: RGBA? = null,
  /**
   * The shape margin fill color (default: transparent).
   */
  public val shapeMarginColor: RGBA? = null,
  /**
   * The grid layout color (default: transparent).
   */
  public val cssGridColor: RGBA? = null,
  /**
   * The color format used to format color styles (default: hex).
   */
  public val colorFormat: ColorFormat? = null,
  /**
   * The grid layout highlight configuration (default: all transparent).
   */
  public val gridHighlightConfig: GridHighlightConfig? = null,
  /**
   * The flex container highlight configuration (default: all transparent).
   */
  public val flexContainerHighlightConfig: FlexContainerHighlightConfig? = null,
  /**
   * The flex item highlight configuration (default: all transparent).
   */
  public val flexItemHighlightConfig: FlexItemHighlightConfig? = null,
  /**
   * The contrast algorithm to use for the contrast ratio (default: aa).
   */
  public val contrastAlgorithm: ContrastAlgorithm? = null,
  /**
   * The container query container highlight configuration (default: all transparent).
   */
  public val containerQueryContainerHighlightConfig: ContainerQueryContainerHighlightConfig? = null,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-ColorFormat)
 */
@Serializable
public enum class ColorFormat {
  rgb,
  hsl,
  hwb,
  hex,
}

/**
 * Configurations for Persistent Grid Highlight
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-GridNodeHighlightConfig)
 */
@Serializable
public data class GridNodeHighlightConfig(
  /**
   * A descriptor for the highlight appearance.
   */
  public val gridHighlightConfig: GridHighlightConfig,
  /**
   * Identifier of the node to highlight.
   */
  public val nodeId: NodeId,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-FlexNodeHighlightConfig)
 */
@Serializable
public data class FlexNodeHighlightConfig(
  /**
   * A descriptor for the highlight appearance of flex containers.
   */
  public val flexContainerHighlightConfig: FlexContainerHighlightConfig,
  /**
   * Identifier of the node to highlight.
   */
  public val nodeId: NodeId,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-ScrollSnapContainerHighlightConfig)
 */
@Serializable
public data class ScrollSnapContainerHighlightConfig(
  /**
   * The style of the snapport border (default: transparent)
   */
  public val snapportBorder: LineStyle? = null,
  /**
   * The style of the snap area border (default: transparent)
   */
  public val snapAreaBorder: LineStyle? = null,
  /**
   * The margin highlight fill color (default: transparent).
   */
  public val scrollMarginColor: RGBA? = null,
  /**
   * The padding highlight fill color (default: transparent).
   */
  public val scrollPaddingColor: RGBA? = null,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-ScrollSnapHighlightConfig)
 */
@Serializable
public data class ScrollSnapHighlightConfig(
  /**
   * A descriptor for the highlight appearance of scroll snap containers.
   */
  public val scrollSnapContainerHighlightConfig: ScrollSnapContainerHighlightConfig,
  /**
   * Identifier of the node to highlight.
   */
  public val nodeId: NodeId,
)

/**
 * Configuration for dual screen hinge
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-HingeConfig)
 */
@Serializable
public data class HingeConfig(
  /**
   * A rectangle represent hinge
   */
  public val rect: Rect,
  /**
   * The content box highlight fill color (default: a dark color).
   */
  public val contentColor: RGBA? = null,
  /**
   * The content box highlight outline color (default: transparent).
   */
  public val outlineColor: RGBA? = null,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-ContainerQueryHighlightConfig)
 */
@Serializable
public data class ContainerQueryHighlightConfig(
  /**
   * A descriptor for the highlight appearance of container query containers.
   */
  public val containerQueryContainerHighlightConfig: ContainerQueryContainerHighlightConfig,
  /**
   * Identifier of the container node to highlight.
   */
  public val nodeId: NodeId,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-ContainerQueryContainerHighlightConfig)
 */
@Serializable
public data class ContainerQueryContainerHighlightConfig(
  /**
   * The style of the container border.
   */
  public val containerBorder: LineStyle? = null,
  /**
   * The style of the descendants' borders.
   */
  public val descendantBorder: LineStyle? = null,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-IsolatedElementHighlightConfig)
 */
@Serializable
public data class IsolatedElementHighlightConfig(
  /**
   * A descriptor for the highlight appearance of an element in isolation mode.
   */
  public val isolationModeHighlightConfig: IsolationModeHighlightConfig,
  /**
   * Identifier of the isolated element to highlight.
   */
  public val nodeId: NodeId,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-IsolationModeHighlightConfig)
 */
@Serializable
public data class IsolationModeHighlightConfig(
  /**
   * The fill color of the resizers (default: transparent).
   */
  public val resizerColor: RGBA? = null,
  /**
   * The fill color for resizer handles (default: transparent).
   */
  public val resizerHandleColor: RGBA? = null,
  /**
   * The fill color for the mask covering non-isolated elements (default: transparent).
   */
  public val maskColor: RGBA? = null,
)

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-InspectMode)
 */
@Serializable
public enum class InspectMode {
  searchForNode,
  searchForUAShadowDOM,
  captureAreaScreenshot,
  showDistances,
  none,
}

/**
 * This enum doesn't have a proper description because it was generated from an inline declaration.
 * Its name was inferred based on the place where it is used:
 *  - the property 'pattern' of the type 'LineStyle'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#type-LineStylePattern)
 */
@Serializable
public enum class LineStylePattern {
  dashed,
  dotted,
}
