@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.overlay.events

import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.dom.BackendNodeId
import org.hildan.chrome.devtools.domains.dom.NodeId
import org.hildan.chrome.devtools.domains.page.Viewport

@Serializable
public sealed class OverlayEvent {
  /**
   * Fired when the node should be inspected. This happens after call to `setInspectMode` or when
   * user manually inspects an element.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#event-inspectNodeRequested)
   */
  @Serializable
  public data class InspectNodeRequested(
    /**
     * Id of the node to inspect.
     */
    public val backendNodeId: BackendNodeId,
  ) : OverlayEvent()

  /**
   * Fired when the node should be highlighted. This happens after call to `setInspectMode`.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#event-nodeHighlightRequested)
   */
  @Serializable
  public data class NodeHighlightRequested(
    public val nodeId: NodeId,
  ) : OverlayEvent()

  /**
   * Fired when user asks to capture screenshot of some area on the page.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#event-screenshotRequested)
   */
  @Serializable
  public data class ScreenshotRequested(
    /**
     * Viewport to capture, in device independent pixels (dip).
     */
    public val viewport: Viewport,
  ) : OverlayEvent()

  /**
   * Fired when user cancels the inspect mode.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Overlay/#event-inspectModeCanceled)
   */
  @Serializable
  public object InspectModeCanceled : OverlayEvent()
}
