@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.page

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmOverloads
import kotlinx.coroutines.flow.Flow
import kotlinx.serialization.DeserializationStrategy
import kotlinx.serialization.Serializable
import kotlinx.serialization.serializer
import org.hildan.chrome.devtools.domains.debugger.SearchMatch
import org.hildan.chrome.devtools.domains.dom.Rect
import org.hildan.chrome.devtools.domains.emulation.ScreenOrientation
import org.hildan.chrome.devtools.domains.io.StreamHandle
import org.hildan.chrome.devtools.domains.network.Cookie
import org.hildan.chrome.devtools.domains.network.LoaderId
import org.hildan.chrome.devtools.domains.page.events.PageEvent
import org.hildan.chrome.devtools.domains.runtime.ExecutionContextId
import org.hildan.chrome.devtools.protocol.ChromeDPSession
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi
import org.hildan.chrome.devtools.protocol.request
import org.hildan.chrome.devtools.protocol.typedEvents

/**
 * Request object containing input parameters for the [PageDomain.addScriptToEvaluateOnLoad]
 * command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public data class AddScriptToEvaluateOnLoadRequest(
  public val scriptSource: String,
)

/**
 * Response type for the [PageDomain.addScriptToEvaluateOnLoad] command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public data class AddScriptToEvaluateOnLoadResponse(
  /**
   * Identifier of the added script.
   */
  public val identifier: ScriptIdentifier,
)

/**
 * Request object containing input parameters for the [PageDomain.addScriptToEvaluateOnNewDocument]
 * command.
 */
@Serializable
public data class AddScriptToEvaluateOnNewDocumentRequest(
  public val source: String,
  /**
   * If specified, creates an isolated world with the given name and evaluates given script in it.
   * This world name will be used as the ExecutionContextDescription::name when the corresponding
   * event is emitted.
   */
  @ExperimentalChromeApi
  public val worldName: String? = null,
  /**
   * Specifies whether command line API should be available to the script, defaults
   * to false.
   */
  @ExperimentalChromeApi
  public val includeCommandLineAPI: Boolean? = null,
) {
  public class Builder(
    public val source: String,
  ) {
    /**
     * If specified, creates an isolated world with the given name and evaluates given script in it.
     * This world name will be used as the ExecutionContextDescription::name when the corresponding
     * event is emitted.
     */
    @ExperimentalChromeApi
    public var worldName: String? = null

    /**
     * Specifies whether command line API should be available to the script, defaults
     * to false.
     */
    @ExperimentalChromeApi
    public var includeCommandLineAPI: Boolean? = null

    public fun build(): AddScriptToEvaluateOnNewDocumentRequest =
        AddScriptToEvaluateOnNewDocumentRequest(source, worldName, includeCommandLineAPI)
  }
}

/**
 * Response type for the [PageDomain.addScriptToEvaluateOnNewDocument] command.
 */
@Serializable
public data class AddScriptToEvaluateOnNewDocumentResponse(
  /**
   * Identifier of the added script.
   */
  public val identifier: ScriptIdentifier,
)

/**
 * A dummy response object for the [PageDomain.bringToFront] command. This command doesn't return
 * any result at the moment, but this could happen in the future, or could have happened in the past.
 * For forwards and backwards compatibility of the command method, we still declare this class even
 * without properties.
 */
@Serializable
public object BringToFrontResponse

/**
 * Request object containing input parameters for the [PageDomain.captureScreenshot] command.
 */
@Serializable
public data class CaptureScreenshotRequest(
  /**
   * Image compression format (defaults to png).
   */
  public val format: ScreenshotFormat? = null,
  /**
   * Compression quality from range [0..100] (jpeg only).
   */
  public val quality: Int? = null,
  /**
   * Capture the screenshot of a given region only.
   */
  public val clip: Viewport? = null,
  /**
   * Capture the screenshot from the surface, rather than the view. Defaults to true.
   */
  @ExperimentalChromeApi
  public val fromSurface: Boolean? = null,
  /**
   * Capture the screenshot beyond the viewport. Defaults to false.
   */
  @ExperimentalChromeApi
  public val captureBeyondViewport: Boolean? = null,
  /**
   * Optimize image encoding for speed, not for resulting size (defaults to false)
   */
  @ExperimentalChromeApi
  public val optimizeForSpeed: Boolean? = null,
) {
  public class Builder() {
    /**
     * Image compression format (defaults to png).
     */
    public var format: ScreenshotFormat? = null

    /**
     * Compression quality from range [0..100] (jpeg only).
     */
    public var quality: Int? = null

    /**
     * Capture the screenshot of a given region only.
     */
    public var clip: Viewport? = null

    /**
     * Capture the screenshot from the surface, rather than the view. Defaults to true.
     */
    @ExperimentalChromeApi
    public var fromSurface: Boolean? = null

    /**
     * Capture the screenshot beyond the viewport. Defaults to false.
     */
    @ExperimentalChromeApi
    public var captureBeyondViewport: Boolean? = null

    /**
     * Optimize image encoding for speed, not for resulting size (defaults to false)
     */
    @ExperimentalChromeApi
    public var optimizeForSpeed: Boolean? = null

    public fun build(): CaptureScreenshotRequest = CaptureScreenshotRequest(format, quality, clip,
        fromSurface, captureBeyondViewport, optimizeForSpeed)
  }
}

/**
 * Response type for the [PageDomain.captureScreenshot] command.
 */
@Serializable
public data class CaptureScreenshotResponse(
  /**
   * Base64-encoded image data. (Encoded as a base64 string when passed over JSON)
   */
  public val `data`: String,
)

/**
 * Request object containing input parameters for the [PageDomain.captureSnapshot] command.
 */
@Serializable
@ExperimentalChromeApi
public data class CaptureSnapshotRequest(
  /**
   * Format (defaults to mhtml).
   */
  public val format: SnapshotFormat? = null,
) {
  public class Builder() {
    /**
     * Format (defaults to mhtml).
     */
    public var format: SnapshotFormat? = null

    public fun build(): CaptureSnapshotRequest = CaptureSnapshotRequest(format)
  }
}

/**
 * Response type for the [PageDomain.captureSnapshot] command.
 */
@Serializable
@ExperimentalChromeApi
public data class CaptureSnapshotResponse(
  /**
   * Serialized page data.
   */
  public val `data`: String,
)

/**
 * A dummy response object for the [PageDomain.clearDeviceMetricsOverride] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public object ClearDeviceMetricsOverrideResponse

/**
 * A dummy response object for the [PageDomain.clearDeviceOrientationOverride] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public object ClearDeviceOrientationOverrideResponse

/**
 * A dummy response object for the [PageDomain.clearGeolocationOverride] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
public object ClearGeolocationOverrideResponse

/**
 * Request object containing input parameters for the [PageDomain.createIsolatedWorld] command.
 */
@Serializable
public data class CreateIsolatedWorldRequest(
  /**
   * Id of the frame in which the isolated world should be created.
   */
  public val frameId: FrameId,
  /**
   * An optional name which is reported in the Execution Context.
   */
  public val worldName: String? = null,
  /**
   * Whether or not universal access should be granted to the isolated world. This is a powerful
   * option, use with caution.
   */
  public val grantUniveralAccess: Boolean? = null,
) {
  public class Builder(
    /**
     * Id of the frame in which the isolated world should be created.
     */
    public val frameId: FrameId,
  ) {
    /**
     * An optional name which is reported in the Execution Context.
     */
    public var worldName: String? = null

    /**
     * Whether or not universal access should be granted to the isolated world. This is a powerful
     * option, use with caution.
     */
    public var grantUniveralAccess: Boolean? = null

    public fun build(): CreateIsolatedWorldRequest = CreateIsolatedWorldRequest(frameId, worldName,
        grantUniveralAccess)
  }
}

/**
 * Response type for the [PageDomain.createIsolatedWorld] command.
 */
@Serializable
public data class CreateIsolatedWorldResponse(
  /**
   * Execution context of the isolated world.
   */
  public val executionContextId: ExecutionContextId,
)

/**
 * Request object containing input parameters for the [PageDomain.deleteCookie] command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public data class DeleteCookieRequest(
  /**
   * Name of the cookie to remove.
   */
  public val cookieName: String,
  /**
   * URL to match cooke domain and path.
   */
  public val url: String,
)

/**
 * A dummy response object for the [PageDomain.deleteCookie] command. This command doesn't return
 * any result at the moment, but this could happen in the future, or could have happened in the past.
 * For forwards and backwards compatibility of the command method, we still declare this class even
 * without properties.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public object DeleteCookieResponse

/**
 * A dummy response object for the [PageDomain.disable] command. This command doesn't return any
 * result at the moment, but this could happen in the future, or could have happened in the past. For
 * forwards and backwards compatibility of the command method, we still declare this class even without
 * properties.
 */
@Serializable
public object DisableResponse

/**
 * A dummy response object for the [PageDomain.enable] command. This command doesn't return any
 * result at the moment, but this could happen in the future, or could have happened in the past. For
 * forwards and backwards compatibility of the command method, we still declare this class even without
 * properties.
 */
@Serializable
public object EnableResponse

/**
 * Response type for the [PageDomain.getAppManifest] command.
 */
@Serializable
public data class GetAppManifestResponse(
  /**
   * Manifest location.
   */
  public val url: String,
  public val errors: List<AppManifestError>,
  /**
   * Manifest content.
   */
  public val `data`: String? = null,
  /**
   * Parsed manifest properties
   */
  @ExperimentalChromeApi
  public val parsed: AppManifestParsedProperties? = null,
)

/**
 * Response type for the [PageDomain.getInstallabilityErrors] command.
 */
@Serializable
@ExperimentalChromeApi
public data class GetInstallabilityErrorsResponse(
  public val installabilityErrors: List<InstallabilityError>,
)

/**
 * Response type for the [PageDomain.getManifestIcons] command.
 */
@Serializable
@ExperimentalChromeApi
public data class GetManifestIconsResponse(
  public val primaryIcon: String? = null,
)

/**
 * Response type for the [PageDomain.getAppId] command.
 */
@Serializable
@ExperimentalChromeApi
public data class GetAppIdResponse(
  /**
   * App id, either from manifest's id attribute or computed from start_url
   */
  public val appId: String? = null,
  /**
   * Recommendation for manifest's id attribute to match current id computed from start_url
   */
  public val recommendedId: String? = null,
)

/**
 * Request object containing input parameters for the [PageDomain.getAdScriptId] command.
 */
@Serializable
@ExperimentalChromeApi
public data class GetAdScriptIdRequest(
  public val frameId: FrameId,
)

/**
 * Response type for the [PageDomain.getAdScriptId] command.
 */
@Serializable
@ExperimentalChromeApi
public data class GetAdScriptIdResponse(
  /**
   * Identifies the bottom-most script which caused the frame to be labelled
   * as an ad. Only sent if frame is labelled as an ad and id is available.
   */
  public val adScriptId: AdScriptId? = null,
)

/**
 * Response type for the [PageDomain.getCookies] command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public data class GetCookiesResponse(
  /**
   * Array of cookie objects.
   */
  public val cookies: List<Cookie>,
)

/**
 * Response type for the [PageDomain.getFrameTree] command.
 */
@Serializable
public data class GetFrameTreeResponse(
  /**
   * Present frame tree structure.
   */
  public val frameTree: FrameTree,
)

/**
 * Response type for the [PageDomain.getLayoutMetrics] command.
 */
@Serializable
public data class GetLayoutMetricsResponse(
  /**
   * Deprecated metrics relating to the layout viewport. Is in device pixels. Use
   * `cssLayoutViewport` instead.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public val layoutViewport: LayoutViewport,
  /**
   * Deprecated metrics relating to the visual viewport. Is in device pixels. Use
   * `cssVisualViewport` instead.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public val visualViewport: VisualViewport,
  /**
   * Deprecated size of scrollable area. Is in DP. Use `cssContentSize` instead.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public val contentSize: Rect,
  /**
   * Metrics relating to the layout viewport in CSS pixels.
   */
  public val cssLayoutViewport: LayoutViewport,
  /**
   * Metrics relating to the visual viewport in CSS pixels.
   */
  public val cssVisualViewport: VisualViewport,
  /**
   * Size of scrollable area in CSS pixels.
   */
  public val cssContentSize: Rect,
)

/**
 * Response type for the [PageDomain.getNavigationHistory] command.
 */
@Serializable
public data class GetNavigationHistoryResponse(
  /**
   * Index of the current navigation history entry.
   */
  public val currentIndex: Int,
  /**
   * Array of navigation history entries.
   */
  public val entries: List<NavigationEntry>,
)

/**
 * A dummy response object for the [PageDomain.resetNavigationHistory] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
public object ResetNavigationHistoryResponse

/**
 * Request object containing input parameters for the [PageDomain.getResourceContent] command.
 */
@Serializable
@ExperimentalChromeApi
public data class GetResourceContentRequest(
  /**
   * Frame id to get resource for.
   */
  public val frameId: FrameId,
  /**
   * URL of the resource to get content for.
   */
  public val url: String,
)

/**
 * Response type for the [PageDomain.getResourceContent] command.
 */
@Serializable
@ExperimentalChromeApi
public data class GetResourceContentResponse(
  /**
   * Resource content.
   */
  public val content: String,
  /**
   * True, if content was served as base64.
   */
  public val base64Encoded: Boolean,
)

/**
 * Response type for the [PageDomain.getResourceTree] command.
 */
@Serializable
@ExperimentalChromeApi
public data class GetResourceTreeResponse(
  /**
   * Present frame / resource tree structure.
   */
  public val frameTree: FrameResourceTree,
)

/**
 * Request object containing input parameters for the [PageDomain.handleJavaScriptDialog] command.
 */
@Serializable
public data class HandleJavaScriptDialogRequest(
  /**
   * Whether to accept or dismiss the dialog.
   */
  public val accept: Boolean,
  /**
   * The text to enter into the dialog prompt before accepting. Used only if this is a prompt
   * dialog.
   */
  public val promptText: String? = null,
) {
  public class Builder(
    /**
     * Whether to accept or dismiss the dialog.
     */
    public val accept: Boolean,
  ) {
    /**
     * The text to enter into the dialog prompt before accepting. Used only if this is a prompt
     * dialog.
     */
    public var promptText: String? = null

    public fun build(): HandleJavaScriptDialogRequest = HandleJavaScriptDialogRequest(accept,
        promptText)
  }
}

/**
 * A dummy response object for the [PageDomain.handleJavaScriptDialog] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
public object HandleJavaScriptDialogResponse

/**
 * Request object containing input parameters for the [PageDomain.navigate] command.
 */
@Serializable
public data class NavigateRequest(
  /**
   * URL to navigate the page to.
   */
  public val url: String,
  /**
   * Referrer URL.
   */
  public val referrer: String? = null,
  /**
   * Intended transition type.
   */
  public val transitionType: TransitionType? = null,
  /**
   * Frame id to navigate, if not specified navigates the top frame.
   */
  public val frameId: FrameId? = null,
  /**
   * Referrer-policy used for the navigation.
   */
  @ExperimentalChromeApi
  public val referrerPolicy: ReferrerPolicy? = null,
) {
  public class Builder(
    /**
     * URL to navigate the page to.
     */
    public val url: String,
  ) {
    /**
     * Referrer URL.
     */
    public var referrer: String? = null

    /**
     * Intended transition type.
     */
    public var transitionType: TransitionType? = null

    /**
     * Frame id to navigate, if not specified navigates the top frame.
     */
    public var frameId: FrameId? = null

    /**
     * Referrer-policy used for the navigation.
     */
    @ExperimentalChromeApi
    public var referrerPolicy: ReferrerPolicy? = null

    public fun build(): NavigateRequest = NavigateRequest(url, referrer, transitionType, frameId,
        referrerPolicy)
  }
}

/**
 * Response type for the [PageDomain.navigate] command.
 */
@Serializable
public data class NavigateResponse(
  /**
   * Frame id that has navigated (or failed to navigate)
   */
  public val frameId: FrameId,
  /**
   * Loader identifier. This is omitted in case of same-document navigation,
   * as the previously committed loaderId would not change.
   */
  public val loaderId: LoaderId? = null,
  /**
   * User friendly error message, present if and only if navigation has failed.
   */
  public val errorText: String? = null,
)

/**
 * Request object containing input parameters for the [PageDomain.navigateToHistoryEntry] command.
 */
@Serializable
public data class NavigateToHistoryEntryRequest(
  /**
   * Unique id of the entry to navigate to.
   */
  public val entryId: Int,
)

/**
 * A dummy response object for the [PageDomain.navigateToHistoryEntry] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
public object NavigateToHistoryEntryResponse

/**
 * Request object containing input parameters for the [PageDomain.printToPDF] command.
 */
@Serializable
public data class PrintToPDFRequest(
  /**
   * Paper orientation. Defaults to false.
   */
  public val landscape: Boolean? = null,
  /**
   * Display header and footer. Defaults to false.
   */
  public val displayHeaderFooter: Boolean? = null,
  /**
   * Print background graphics. Defaults to false.
   */
  public val printBackground: Boolean? = null,
  /**
   * Scale of the webpage rendering. Defaults to 1.
   */
  public val scale: Double? = null,
  /**
   * Paper width in inches. Defaults to 8.5 inches.
   */
  public val paperWidth: Double? = null,
  /**
   * Paper height in inches. Defaults to 11 inches.
   */
  public val paperHeight: Double? = null,
  /**
   * Top margin in inches. Defaults to 1cm (~0.4 inches).
   */
  public val marginTop: Double? = null,
  /**
   * Bottom margin in inches. Defaults to 1cm (~0.4 inches).
   */
  public val marginBottom: Double? = null,
  /**
   * Left margin in inches. Defaults to 1cm (~0.4 inches).
   */
  public val marginLeft: Double? = null,
  /**
   * Right margin in inches. Defaults to 1cm (~0.4 inches).
   */
  public val marginRight: Double? = null,
  /**
   * Paper ranges to print, one based, e.g., '1-5, 8, 11-13'. Pages are
   * printed in the document order, not in the order specified, and no
   * more than once.
   * Defaults to empty string, which implies the entire document is printed.
   * The page numbers are quietly capped to actual page count of the
   * document, and ranges beyond the end of the document are ignored.
   * If this results in no pages to print, an error is reported.
   * It is an error to specify a range with start greater than end.
   */
  public val pageRanges: String? = null,
  /**
   * HTML template for the print header. Should be valid HTML markup with following
   * classes used to inject printing values into them:
   * - `date`: formatted print date
   * - `title`: document title
   * - `url`: document location
   * - `pageNumber`: current page number
   * - `totalPages`: total pages in the document
   *
   * For example, `<span class=title></span>` would generate span containing the title.
   */
  public val headerTemplate: String? = null,
  /**
   * HTML template for the print footer. Should use the same format as the `headerTemplate`.
   */
  public val footerTemplate: String? = null,
  /**
   * Whether or not to prefer page size as defined by css. Defaults to false,
   * in which case the content will be scaled to fit the paper size.
   */
  public val preferCSSPageSize: Boolean? = null,
  /**
   * return as stream
   */
  @ExperimentalChromeApi
  public val transferMode: TransferMode? = null,
) {
  public class Builder() {
    /**
     * Paper orientation. Defaults to false.
     */
    public var landscape: Boolean? = null

    /**
     * Display header and footer. Defaults to false.
     */
    public var displayHeaderFooter: Boolean? = null

    /**
     * Print background graphics. Defaults to false.
     */
    public var printBackground: Boolean? = null

    /**
     * Scale of the webpage rendering. Defaults to 1.
     */
    public var scale: Double? = null

    /**
     * Paper width in inches. Defaults to 8.5 inches.
     */
    public var paperWidth: Double? = null

    /**
     * Paper height in inches. Defaults to 11 inches.
     */
    public var paperHeight: Double? = null

    /**
     * Top margin in inches. Defaults to 1cm (~0.4 inches).
     */
    public var marginTop: Double? = null

    /**
     * Bottom margin in inches. Defaults to 1cm (~0.4 inches).
     */
    public var marginBottom: Double? = null

    /**
     * Left margin in inches. Defaults to 1cm (~0.4 inches).
     */
    public var marginLeft: Double? = null

    /**
     * Right margin in inches. Defaults to 1cm (~0.4 inches).
     */
    public var marginRight: Double? = null

    /**
     * Paper ranges to print, one based, e.g., '1-5, 8, 11-13'. Pages are
     * printed in the document order, not in the order specified, and no
     * more than once.
     * Defaults to empty string, which implies the entire document is printed.
     * The page numbers are quietly capped to actual page count of the
     * document, and ranges beyond the end of the document are ignored.
     * If this results in no pages to print, an error is reported.
     * It is an error to specify a range with start greater than end.
     */
    public var pageRanges: String? = null

    /**
     * HTML template for the print header. Should be valid HTML markup with following
     * classes used to inject printing values into them:
     * - `date`: formatted print date
     * - `title`: document title
     * - `url`: document location
     * - `pageNumber`: current page number
     * - `totalPages`: total pages in the document
     *
     * For example, `<span class=title></span>` would generate span containing the title.
     */
    public var headerTemplate: String? = null

    /**
     * HTML template for the print footer. Should use the same format as the `headerTemplate`.
     */
    public var footerTemplate: String? = null

    /**
     * Whether or not to prefer page size as defined by css. Defaults to false,
     * in which case the content will be scaled to fit the paper size.
     */
    public var preferCSSPageSize: Boolean? = null

    /**
     * return as stream
     */
    @ExperimentalChromeApi
    public var transferMode: TransferMode? = null

    public fun build(): PrintToPDFRequest = PrintToPDFRequest(landscape, displayHeaderFooter,
        printBackground, scale, paperWidth, paperHeight, marginTop, marginBottom, marginLeft,
        marginRight, pageRanges, headerTemplate, footerTemplate, preferCSSPageSize, transferMode)
  }
}

/**
 * Response type for the [PageDomain.printToPDF] command.
 */
@Serializable
public data class PrintToPDFResponse(
  /**
   * Base64-encoded pdf data. Empty if |returnAsStream| is specified. (Encoded as a base64 string
   * when passed over JSON)
   */
  public val `data`: String,
  /**
   * A handle of the stream that holds resulting PDF data.
   */
  @ExperimentalChromeApi
  public val stream: StreamHandle? = null,
)

/**
 * Request object containing input parameters for the [PageDomain.reload] command.
 */
@Serializable
public data class ReloadRequest(
  /**
   * If true, browser cache is ignored (as if the user pressed Shift+refresh).
   */
  public val ignoreCache: Boolean? = null,
  /**
   * If set, the script will be injected into all frames of the inspected page after reload.
   * Argument will be ignored if reloading dataURL origin.
   */
  public val scriptToEvaluateOnLoad: String? = null,
) {
  public class Builder() {
    /**
     * If true, browser cache is ignored (as if the user pressed Shift+refresh).
     */
    public var ignoreCache: Boolean? = null

    /**
     * If set, the script will be injected into all frames of the inspected page after reload.
     * Argument will be ignored if reloading dataURL origin.
     */
    public var scriptToEvaluateOnLoad: String? = null

    public fun build(): ReloadRequest = ReloadRequest(ignoreCache, scriptToEvaluateOnLoad)
  }
}

/**
 * A dummy response object for the [PageDomain.reload] command. This command doesn't return any
 * result at the moment, but this could happen in the future, or could have happened in the past. For
 * forwards and backwards compatibility of the command method, we still declare this class even without
 * properties.
 */
@Serializable
public object ReloadResponse

/**
 * Request object containing input parameters for the [PageDomain.removeScriptToEvaluateOnLoad]
 * command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public data class RemoveScriptToEvaluateOnLoadRequest(
  public val identifier: ScriptIdentifier,
)

/**
 * A dummy response object for the [PageDomain.removeScriptToEvaluateOnLoad] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public object RemoveScriptToEvaluateOnLoadResponse

/**
 * Request object containing input parameters for the
 * [PageDomain.removeScriptToEvaluateOnNewDocument] command.
 */
@Serializable
public data class RemoveScriptToEvaluateOnNewDocumentRequest(
  public val identifier: ScriptIdentifier,
)

/**
 * A dummy response object for the [PageDomain.removeScriptToEvaluateOnNewDocument] command. This
 * command doesn't return any result at the moment, but this could happen in the future, or could have
 * happened in the past. For forwards and backwards compatibility of the command method, we still
 * declare this class even without properties.
 */
@Serializable
public object RemoveScriptToEvaluateOnNewDocumentResponse

/**
 * Request object containing input parameters for the [PageDomain.screencastFrameAck] command.
 */
@Serializable
@ExperimentalChromeApi
public data class ScreencastFrameAckRequest(
  /**
   * Frame number.
   */
  public val sessionId: Int,
)

/**
 * A dummy response object for the [PageDomain.screencastFrameAck] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
@ExperimentalChromeApi
public object ScreencastFrameAckResponse

/**
 * Request object containing input parameters for the [PageDomain.searchInResource] command.
 */
@Serializable
@ExperimentalChromeApi
public data class SearchInResourceRequest(
  /**
   * Frame id for resource to search in.
   */
  public val frameId: FrameId,
  /**
   * URL of the resource to search in.
   */
  public val url: String,
  /**
   * String to search for.
   */
  public val query: String,
  /**
   * If true, search is case sensitive.
   */
  public val caseSensitive: Boolean? = null,
  /**
   * If true, treats string parameter as regex.
   */
  public val isRegex: Boolean? = null,
) {
  public class Builder(
    /**
     * Frame id for resource to search in.
     */
    public val frameId: FrameId,
    /**
     * URL of the resource to search in.
     */
    public val url: String,
    /**
     * String to search for.
     */
    public val query: String,
  ) {
    /**
     * If true, search is case sensitive.
     */
    public var caseSensitive: Boolean? = null

    /**
     * If true, treats string parameter as regex.
     */
    public var isRegex: Boolean? = null

    public fun build(): SearchInResourceRequest = SearchInResourceRequest(frameId, url, query,
        caseSensitive, isRegex)
  }
}

/**
 * Response type for the [PageDomain.searchInResource] command.
 */
@Serializable
@ExperimentalChromeApi
public data class SearchInResourceResponse(
  /**
   * List of search matches.
   */
  public val result: List<SearchMatch>,
)

/**
 * Request object containing input parameters for the [PageDomain.setAdBlockingEnabled] command.
 */
@Serializable
@ExperimentalChromeApi
public data class SetAdBlockingEnabledRequest(
  /**
   * Whether to block ads.
   */
  public val enabled: Boolean,
)

/**
 * A dummy response object for the [PageDomain.setAdBlockingEnabled] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
@ExperimentalChromeApi
public object SetAdBlockingEnabledResponse

/**
 * Request object containing input parameters for the [PageDomain.setBypassCSP] command.
 */
@Serializable
@ExperimentalChromeApi
public data class SetBypassCSPRequest(
  /**
   * Whether to bypass page CSP.
   */
  public val enabled: Boolean,
)

/**
 * A dummy response object for the [PageDomain.setBypassCSP] command. This command doesn't return
 * any result at the moment, but this could happen in the future, or could have happened in the past.
 * For forwards and backwards compatibility of the command method, we still declare this class even
 * without properties.
 */
@Serializable
@ExperimentalChromeApi
public object SetBypassCSPResponse

/**
 * Request object containing input parameters for the [PageDomain.getPermissionsPolicyState]
 * command.
 */
@Serializable
@ExperimentalChromeApi
public data class GetPermissionsPolicyStateRequest(
  public val frameId: FrameId,
)

/**
 * Response type for the [PageDomain.getPermissionsPolicyState] command.
 */
@Serializable
@ExperimentalChromeApi
public data class GetPermissionsPolicyStateResponse(
  public val states: List<PermissionsPolicyFeatureState>,
)

/**
 * Request object containing input parameters for the [PageDomain.getOriginTrials] command.
 */
@Serializable
@ExperimentalChromeApi
public data class GetOriginTrialsRequest(
  public val frameId: FrameId,
)

/**
 * Response type for the [PageDomain.getOriginTrials] command.
 */
@Serializable
@ExperimentalChromeApi
public data class GetOriginTrialsResponse(
  public val originTrials: List<OriginTrial>,
)

/**
 * Request object containing input parameters for the [PageDomain.setDeviceMetricsOverride] command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public data class SetDeviceMetricsOverrideRequest(
  /**
   * Overriding width value in pixels (minimum 0, maximum 10000000). 0 disables the override.
   */
  public val width: Int,
  /**
   * Overriding height value in pixels (minimum 0, maximum 10000000). 0 disables the override.
   */
  public val height: Int,
  /**
   * Overriding device scale factor value. 0 disables the override.
   */
  public val deviceScaleFactor: Double,
  /**
   * Whether to emulate mobile device. This includes viewport meta tag, overlay scrollbars, text
   * autosizing and more.
   */
  public val mobile: Boolean,
  /**
   * Scale to apply to resulting view image.
   */
  public val scale: Double? = null,
  /**
   * Overriding screen width value in pixels (minimum 0, maximum 10000000).
   */
  public val screenWidth: Int? = null,
  /**
   * Overriding screen height value in pixels (minimum 0, maximum 10000000).
   */
  public val screenHeight: Int? = null,
  /**
   * Overriding view X position on screen in pixels (minimum 0, maximum 10000000).
   */
  public val positionX: Int? = null,
  /**
   * Overriding view Y position on screen in pixels (minimum 0, maximum 10000000).
   */
  public val positionY: Int? = null,
  /**
   * Do not set visible view size, rely upon explicit setVisibleSize call.
   */
  public val dontSetVisibleSize: Boolean? = null,
  /**
   * Screen orientation override.
   */
  public val screenOrientation: ScreenOrientation? = null,
  /**
   * The viewport dimensions and scale. If not set, the override is cleared.
   */
  public val viewport: Viewport? = null,
) {
  public class Builder(
    /**
     * Overriding width value in pixels (minimum 0, maximum 10000000). 0 disables the override.
     */
    public val width: Int,
    /**
     * Overriding height value in pixels (minimum 0, maximum 10000000). 0 disables the override.
     */
    public val height: Int,
    /**
     * Overriding device scale factor value. 0 disables the override.
     */
    public val deviceScaleFactor: Double,
    /**
     * Whether to emulate mobile device. This includes viewport meta tag, overlay scrollbars, text
     * autosizing and more.
     */
    public val mobile: Boolean,
  ) {
    /**
     * Scale to apply to resulting view image.
     */
    public var scale: Double? = null

    /**
     * Overriding screen width value in pixels (minimum 0, maximum 10000000).
     */
    public var screenWidth: Int? = null

    /**
     * Overriding screen height value in pixels (minimum 0, maximum 10000000).
     */
    public var screenHeight: Int? = null

    /**
     * Overriding view X position on screen in pixels (minimum 0, maximum 10000000).
     */
    public var positionX: Int? = null

    /**
     * Overriding view Y position on screen in pixels (minimum 0, maximum 10000000).
     */
    public var positionY: Int? = null

    /**
     * Do not set visible view size, rely upon explicit setVisibleSize call.
     */
    public var dontSetVisibleSize: Boolean? = null

    /**
     * Screen orientation override.
     */
    public var screenOrientation: ScreenOrientation? = null

    /**
     * The viewport dimensions and scale. If not set, the override is cleared.
     */
    public var viewport: Viewport? = null

    public fun build(): SetDeviceMetricsOverrideRequest = SetDeviceMetricsOverrideRequest(width,
        height, deviceScaleFactor, mobile, scale, screenWidth, screenHeight, positionX, positionY,
        dontSetVisibleSize, screenOrientation, viewport)
  }
}

/**
 * A dummy response object for the [PageDomain.setDeviceMetricsOverride] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public object SetDeviceMetricsOverrideResponse

/**
 * Request object containing input parameters for the [PageDomain.setDeviceOrientationOverride]
 * command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public data class SetDeviceOrientationOverrideRequest(
  /**
   * Mock alpha
   */
  public val alpha: Double,
  /**
   * Mock beta
   */
  public val beta: Double,
  /**
   * Mock gamma
   */
  public val gamma: Double,
)

/**
 * A dummy response object for the [PageDomain.setDeviceOrientationOverride] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public object SetDeviceOrientationOverrideResponse

/**
 * Request object containing input parameters for the [PageDomain.setFontFamilies] command.
 */
@Serializable
@ExperimentalChromeApi
public data class SetFontFamiliesRequest(
  /**
   * Specifies font families to set. If a font family is not specified, it won't be changed.
   */
  public val fontFamilies: FontFamilies,
  /**
   * Specifies font families to set for individual scripts.
   */
  public val forScripts: List<ScriptFontFamilies>? = null,
) {
  public class Builder(
    /**
     * Specifies font families to set. If a font family is not specified, it won't be changed.
     */
    public val fontFamilies: FontFamilies,
  ) {
    /**
     * Specifies font families to set for individual scripts.
     */
    public var forScripts: List<ScriptFontFamilies>? = null

    public fun build(): SetFontFamiliesRequest = SetFontFamiliesRequest(fontFamilies, forScripts)
  }
}

/**
 * A dummy response object for the [PageDomain.setFontFamilies] command. This command doesn't return
 * any result at the moment, but this could happen in the future, or could have happened in the past.
 * For forwards and backwards compatibility of the command method, we still declare this class even
 * without properties.
 */
@Serializable
@ExperimentalChromeApi
public object SetFontFamiliesResponse

/**
 * Request object containing input parameters for the [PageDomain.setFontSizes] command.
 */
@Serializable
@ExperimentalChromeApi
public data class SetFontSizesRequest(
  /**
   * Specifies font sizes to set. If a font size is not specified, it won't be changed.
   */
  public val fontSizes: FontSizes,
)

/**
 * A dummy response object for the [PageDomain.setFontSizes] command. This command doesn't return
 * any result at the moment, but this could happen in the future, or could have happened in the past.
 * For forwards and backwards compatibility of the command method, we still declare this class even
 * without properties.
 */
@Serializable
@ExperimentalChromeApi
public object SetFontSizesResponse

/**
 * Request object containing input parameters for the [PageDomain.setDocumentContent] command.
 */
@Serializable
public data class SetDocumentContentRequest(
  /**
   * Frame id to set HTML for.
   */
  public val frameId: FrameId,
  /**
   * HTML content to set.
   */
  public val html: String,
)

/**
 * A dummy response object for the [PageDomain.setDocumentContent] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
public object SetDocumentContentResponse

/**
 * Request object containing input parameters for the [PageDomain.setDownloadBehavior] command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public data class SetDownloadBehaviorRequest(
  /**
   * Whether to allow all or deny all download requests, or use default Chrome behavior if
   * available (otherwise deny).
   */
  public val behavior: DownloadBehavior,
  /**
   * The default path to save downloaded files to. This is required if behavior is set to 'allow'
   */
  public val downloadPath: String? = null,
) {
  public class Builder(
    /**
     * Whether to allow all or deny all download requests, or use default Chrome behavior if
     * available (otherwise deny).
     */
    public val behavior: DownloadBehavior,
  ) {
    /**
     * The default path to save downloaded files to. This is required if behavior is set to 'allow'
     */
    public var downloadPath: String? = null

    public fun build(): SetDownloadBehaviorRequest = SetDownloadBehaviorRequest(behavior,
        downloadPath)
  }
}

/**
 * A dummy response object for the [PageDomain.setDownloadBehavior] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public object SetDownloadBehaviorResponse

/**
 * Request object containing input parameters for the [PageDomain.setGeolocationOverride] command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
public data class SetGeolocationOverrideRequest(
  /**
   * Mock latitude
   */
  public val latitude: Double? = null,
  /**
   * Mock longitude
   */
  public val longitude: Double? = null,
  /**
   * Mock accuracy
   */
  public val accuracy: Double? = null,
) {
  public class Builder() {
    /**
     * Mock latitude
     */
    public var latitude: Double? = null

    /**
     * Mock longitude
     */
    public var longitude: Double? = null

    /**
     * Mock accuracy
     */
    public var accuracy: Double? = null

    public fun build(): SetGeolocationOverrideRequest = SetGeolocationOverrideRequest(latitude,
        longitude, accuracy)
  }
}

/**
 * A dummy response object for the [PageDomain.setGeolocationOverride] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
public object SetGeolocationOverrideResponse

/**
 * Request object containing input parameters for the [PageDomain.setLifecycleEventsEnabled]
 * command.
 */
@Serializable
@ExperimentalChromeApi
public data class SetLifecycleEventsEnabledRequest(
  /**
   * If true, starts emitting lifecycle events.
   */
  public val enabled: Boolean,
)

/**
 * A dummy response object for the [PageDomain.setLifecycleEventsEnabled] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
@ExperimentalChromeApi
public object SetLifecycleEventsEnabledResponse

/**
 * Request object containing input parameters for the [PageDomain.setTouchEmulationEnabled] command.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public data class SetTouchEmulationEnabledRequest(
  /**
   * Whether the touch event emulation should be enabled.
   */
  public val enabled: Boolean,
  /**
   * Touch/gesture events configuration. Default: current platform.
   */
  public val configuration: TouchEmulationEnabledConfiguration? = null,
) {
  public class Builder(
    /**
     * Whether the touch event emulation should be enabled.
     */
    public val enabled: Boolean,
  ) {
    /**
     * Touch/gesture events configuration. Default: current platform.
     */
    public var configuration: TouchEmulationEnabledConfiguration? = null

    public fun build(): SetTouchEmulationEnabledRequest = SetTouchEmulationEnabledRequest(enabled,
        configuration)
  }
}

/**
 * A dummy response object for the [PageDomain.setTouchEmulationEnabled] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
@Deprecated(message = "Deprecated in the Chrome DevTools protocol")
@ExperimentalChromeApi
public object SetTouchEmulationEnabledResponse

/**
 * Request object containing input parameters for the [PageDomain.startScreencast] command.
 */
@Serializable
@ExperimentalChromeApi
public data class StartScreencastRequest(
  /**
   * Image compression format.
   */
  public val format: ScreencastFormat? = null,
  /**
   * Compression quality from range [0..100].
   */
  public val quality: Int? = null,
  /**
   * Maximum screenshot width.
   */
  public val maxWidth: Int? = null,
  /**
   * Maximum screenshot height.
   */
  public val maxHeight: Int? = null,
  /**
   * Send every n-th frame.
   */
  public val everyNthFrame: Int? = null,
) {
  public class Builder() {
    /**
     * Image compression format.
     */
    public var format: ScreencastFormat? = null

    /**
     * Compression quality from range [0..100].
     */
    public var quality: Int? = null

    /**
     * Maximum screenshot width.
     */
    public var maxWidth: Int? = null

    /**
     * Maximum screenshot height.
     */
    public var maxHeight: Int? = null

    /**
     * Send every n-th frame.
     */
    public var everyNthFrame: Int? = null

    public fun build(): StartScreencastRequest = StartScreencastRequest(format, quality, maxWidth,
        maxHeight, everyNthFrame)
  }
}

/**
 * A dummy response object for the [PageDomain.startScreencast] command. This command doesn't return
 * any result at the moment, but this could happen in the future, or could have happened in the past.
 * For forwards and backwards compatibility of the command method, we still declare this class even
 * without properties.
 */
@Serializable
@ExperimentalChromeApi
public object StartScreencastResponse

/**
 * A dummy response object for the [PageDomain.stopLoading] command. This command doesn't return any
 * result at the moment, but this could happen in the future, or could have happened in the past. For
 * forwards and backwards compatibility of the command method, we still declare this class even without
 * properties.
 */
@Serializable
public object StopLoadingResponse

/**
 * A dummy response object for the [PageDomain.crash] command. This command doesn't return any
 * result at the moment, but this could happen in the future, or could have happened in the past. For
 * forwards and backwards compatibility of the command method, we still declare this class even without
 * properties.
 */
@Serializable
@ExperimentalChromeApi
public object CrashResponse

/**
 * A dummy response object for the [PageDomain.close] command. This command doesn't return any
 * result at the moment, but this could happen in the future, or could have happened in the past. For
 * forwards and backwards compatibility of the command method, we still declare this class even without
 * properties.
 */
@Serializable
@ExperimentalChromeApi
public object CloseResponse

/**
 * Request object containing input parameters for the [PageDomain.setWebLifecycleState] command.
 */
@Serializable
@ExperimentalChromeApi
public data class SetWebLifecycleStateRequest(
  /**
   * Target lifecycle state
   */
  public val state: WebLifecycleState,
)

/**
 * A dummy response object for the [PageDomain.setWebLifecycleState] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
@ExperimentalChromeApi
public object SetWebLifecycleStateResponse

/**
 * A dummy response object for the [PageDomain.stopScreencast] command. This command doesn't return
 * any result at the moment, but this could happen in the future, or could have happened in the past.
 * For forwards and backwards compatibility of the command method, we still declare this class even
 * without properties.
 */
@Serializable
@ExperimentalChromeApi
public object StopScreencastResponse

/**
 * Request object containing input parameters for the [PageDomain.produceCompilationCache] command.
 */
@Serializable
@ExperimentalChromeApi
public data class ProduceCompilationCacheRequest(
  public val scripts: List<CompilationCacheParams>,
)

/**
 * A dummy response object for the [PageDomain.produceCompilationCache] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
@ExperimentalChromeApi
public object ProduceCompilationCacheResponse

/**
 * Request object containing input parameters for the [PageDomain.addCompilationCache] command.
 */
@Serializable
@ExperimentalChromeApi
public data class AddCompilationCacheRequest(
  public val url: String,
  /**
   * Base64-encoded data (Encoded as a base64 string when passed over JSON)
   */
  public val `data`: String,
)

/**
 * A dummy response object for the [PageDomain.addCompilationCache] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
@ExperimentalChromeApi
public object AddCompilationCacheResponse

/**
 * A dummy response object for the [PageDomain.clearCompilationCache] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
@ExperimentalChromeApi
public object ClearCompilationCacheResponse

/**
 * Request object containing input parameters for the [PageDomain.setSPCTransactionMode] command.
 */
@Serializable
@ExperimentalChromeApi
public data class SetSPCTransactionModeRequest(
  public val mode: SPCTransactionMode,
)

/**
 * A dummy response object for the [PageDomain.setSPCTransactionMode] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
@ExperimentalChromeApi
public object SetSPCTransactionModeResponse

/**
 * Request object containing input parameters for the [PageDomain.generateTestReport] command.
 */
@Serializable
@ExperimentalChromeApi
public data class GenerateTestReportRequest(
  /**
   * Message to be displayed in the report.
   */
  public val message: String,
  /**
   * Specifies the endpoint group to deliver the report to.
   */
  public val group: String? = null,
) {
  public class Builder(
    /**
     * Message to be displayed in the report.
     */
    public val message: String,
  ) {
    /**
     * Specifies the endpoint group to deliver the report to.
     */
    public var group: String? = null

    public fun build(): GenerateTestReportRequest = GenerateTestReportRequest(message, group)
  }
}

/**
 * A dummy response object for the [PageDomain.generateTestReport] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
@ExperimentalChromeApi
public object GenerateTestReportResponse

/**
 * A dummy response object for the [PageDomain.waitForDebugger] command. This command doesn't return
 * any result at the moment, but this could happen in the future, or could have happened in the past.
 * For forwards and backwards compatibility of the command method, we still declare this class even
 * without properties.
 */
@Serializable
@ExperimentalChromeApi
public object WaitForDebuggerResponse

/**
 * Request object containing input parameters for the [PageDomain.setInterceptFileChooserDialog]
 * command.
 */
@Serializable
@ExperimentalChromeApi
public data class SetInterceptFileChooserDialogRequest(
  public val enabled: Boolean,
)

/**
 * A dummy response object for the [PageDomain.setInterceptFileChooserDialog] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
@ExperimentalChromeApi
public object SetInterceptFileChooserDialogResponse

/**
 * Actions and events related to the inspected page belong to the page domain.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page)
 */
public class PageDomain internal constructor(
  private val session: ChromeDPSession,
) {
  /**
   * Mapping between events and their deserializer.
   */
  private val deserializersByEventName: Map<String, DeserializationStrategy<out PageEvent>> = mapOf(
      "Page.domContentEventFired" to serializer<PageEvent.DomContentEventFired>(),
      "Page.fileChooserOpened" to serializer<PageEvent.FileChooserOpened>(),
      "Page.frameAttached" to serializer<PageEvent.FrameAttached>(),
      "Page.frameClearedScheduledNavigation" to
          serializer<PageEvent.FrameClearedScheduledNavigation>(),
      "Page.frameDetached" to serializer<PageEvent.FrameDetached>(),
      "Page.frameNavigated" to serializer<PageEvent.FrameNavigated>(),
      "Page.documentOpened" to serializer<PageEvent.DocumentOpened>(),
      "Page.frameResized" to serializer<PageEvent.FrameResized>(),
      "Page.frameRequestedNavigation" to serializer<PageEvent.FrameRequestedNavigation>(),
      "Page.frameScheduledNavigation" to serializer<PageEvent.FrameScheduledNavigation>(),
      "Page.frameStartedLoading" to serializer<PageEvent.FrameStartedLoading>(),
      "Page.frameStoppedLoading" to serializer<PageEvent.FrameStoppedLoading>(),
      "Page.downloadWillBegin" to serializer<PageEvent.DownloadWillBegin>(),
      "Page.downloadProgress" to serializer<PageEvent.DownloadProgress>(),
      "Page.interstitialHidden" to serializer<PageEvent.InterstitialHidden>(),
      "Page.interstitialShown" to serializer<PageEvent.InterstitialShown>(),
      "Page.javascriptDialogClosed" to serializer<PageEvent.JavascriptDialogClosed>(),
      "Page.javascriptDialogOpening" to serializer<PageEvent.JavascriptDialogOpening>(),
      "Page.lifecycleEvent" to serializer<PageEvent.LifecycleEvent>(),
      "Page.backForwardCacheNotUsed" to serializer<PageEvent.BackForwardCacheNotUsed>(),
      "Page.prerenderAttemptCompleted" to serializer<PageEvent.PrerenderAttemptCompleted>(),
      "Page.loadEventFired" to serializer<PageEvent.LoadEventFired>(),
      "Page.navigatedWithinDocument" to serializer<PageEvent.NavigatedWithinDocument>(),
      "Page.screencastFrame" to serializer<PageEvent.ScreencastFrame>(),
      "Page.screencastVisibilityChanged" to serializer<PageEvent.ScreencastVisibilityChanged>(),
      "Page.windowOpen" to serializer<PageEvent.WindowOpen>(),
      "Page.compilationCacheProduced" to serializer<PageEvent.CompilationCacheProduced>(),
      )

  /**
   * Subscribes to all events related to this domain.
   */
  public fun events(): Flow<PageEvent> = session.typedEvents(deserializersByEventName)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-domContentEventFired)
   */
  public fun domContentEventFiredEvents(): Flow<PageEvent.DomContentEventFired> =
      session.typedEvents("Page.domContentEventFired")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("domContentEventFiredEvents()"),
  )
  public fun domContentEventFired(): Flow<PageEvent.DomContentEventFired> =
      domContentEventFiredEvents()

  /**
   * Emitted only when `page.interceptFileChooser` is enabled.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-fileChooserOpened)
   */
  public fun fileChooserOpenedEvents(): Flow<PageEvent.FileChooserOpened> =
      session.typedEvents("Page.fileChooserOpened")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("fileChooserOpenedEvents()"),
  )
  public fun fileChooserOpened(): Flow<PageEvent.FileChooserOpened> = fileChooserOpenedEvents()

  /**
   * Fired when frame has been attached to its parent.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-frameAttached)
   */
  public fun frameAttachedEvents(): Flow<PageEvent.FrameAttached> =
      session.typedEvents("Page.frameAttached")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("frameAttachedEvents()"),
  )
  public fun frameAttached(): Flow<PageEvent.FrameAttached> = frameAttachedEvents()

  /**
   * Fired when frame no longer has a scheduled navigation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-frameClearedScheduledNavigation)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public fun frameClearedScheduledNavigationEvents():
      Flow<PageEvent.FrameClearedScheduledNavigation> =
      session.typedEvents("Page.frameClearedScheduledNavigation")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("frameClearedScheduledNavigationEvents()"),
  )
  public fun frameClearedScheduledNavigation(): Flow<PageEvent.FrameClearedScheduledNavigation> =
      frameClearedScheduledNavigationEvents()

  /**
   * Fired when frame has been detached from its parent.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-frameDetached)
   */
  public fun frameDetachedEvents(): Flow<PageEvent.FrameDetached> =
      session.typedEvents("Page.frameDetached")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("frameDetachedEvents()"),
  )
  public fun frameDetached(): Flow<PageEvent.FrameDetached> = frameDetachedEvents()

  /**
   * Fired once navigation of the frame has completed. Frame is now associated with the new loader.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-frameNavigated)
   */
  public fun frameNavigatedEvents(): Flow<PageEvent.FrameNavigated> =
      session.typedEvents("Page.frameNavigated")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("frameNavigatedEvents()"),
  )
  public fun frameNavigated(): Flow<PageEvent.FrameNavigated> = frameNavigatedEvents()

  /**
   * Fired when opening document to write to.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-documentOpened)
   */
  @ExperimentalChromeApi
  public fun documentOpenedEvents(): Flow<PageEvent.DocumentOpened> =
      session.typedEvents("Page.documentOpened")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("documentOpenedEvents()"),
  )
  public fun documentOpened(): Flow<PageEvent.DocumentOpened> = documentOpenedEvents()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-frameResized)
   */
  @ExperimentalChromeApi
  public fun frameResizedEvents(): Flow<PageEvent.FrameResized> =
      session.typedEvents("Page.frameResized")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("frameResizedEvents()"),
  )
  public fun frameResized(): Flow<PageEvent.FrameResized> = frameResizedEvents()

  /**
   * Fired when a renderer-initiated navigation is requested.
   * Navigation may still be cancelled after the event is issued.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-frameRequestedNavigation)
   */
  @ExperimentalChromeApi
  public fun frameRequestedNavigationEvents(): Flow<PageEvent.FrameRequestedNavigation> =
      session.typedEvents("Page.frameRequestedNavigation")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("frameRequestedNavigationEvents()"),
  )
  public fun frameRequestedNavigation(): Flow<PageEvent.FrameRequestedNavigation> =
      frameRequestedNavigationEvents()

  /**
   * Fired when frame schedules a potential navigation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-frameScheduledNavigation)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public fun frameScheduledNavigationEvents(): Flow<PageEvent.FrameScheduledNavigation> =
      session.typedEvents("Page.frameScheduledNavigation")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("frameScheduledNavigationEvents()"),
  )
  public fun frameScheduledNavigation(): Flow<PageEvent.FrameScheduledNavigation> =
      frameScheduledNavigationEvents()

  /**
   * Fired when frame has started loading.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-frameStartedLoading)
   */
  @ExperimentalChromeApi
  public fun frameStartedLoadingEvents(): Flow<PageEvent.FrameStartedLoading> =
      session.typedEvents("Page.frameStartedLoading")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("frameStartedLoadingEvents()"),
  )
  public fun frameStartedLoading(): Flow<PageEvent.FrameStartedLoading> =
      frameStartedLoadingEvents()

  /**
   * Fired when frame has stopped loading.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-frameStoppedLoading)
   */
  @ExperimentalChromeApi
  public fun frameStoppedLoadingEvents(): Flow<PageEvent.FrameStoppedLoading> =
      session.typedEvents("Page.frameStoppedLoading")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("frameStoppedLoadingEvents()"),
  )
  public fun frameStoppedLoading(): Flow<PageEvent.FrameStoppedLoading> =
      frameStoppedLoadingEvents()

  /**
   * Fired when page is about to start a download.
   * Deprecated. Use Browser.downloadWillBegin instead.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-downloadWillBegin)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public fun downloadWillBeginEvents(): Flow<PageEvent.DownloadWillBegin> =
      session.typedEvents("Page.downloadWillBegin")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("downloadWillBeginEvents()"),
  )
  public fun downloadWillBegin(): Flow<PageEvent.DownloadWillBegin> = downloadWillBeginEvents()

  /**
   * Fired when download makes progress. Last call has |done| == true.
   * Deprecated. Use Browser.downloadProgress instead.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-downloadProgress)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public fun downloadProgressEvents(): Flow<PageEvent.DownloadProgress> =
      session.typedEvents("Page.downloadProgress")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("downloadProgressEvents()"),
  )
  public fun downloadProgress(): Flow<PageEvent.DownloadProgress> = downloadProgressEvents()

  /**
   * Fired when interstitial page was hidden
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-interstitialHidden)
   */
  public fun interstitialHiddenEvents(): Flow<PageEvent.InterstitialHidden> =
      session.typedEvents("Page.interstitialHidden")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("interstitialHiddenEvents()"),
  )
  public fun interstitialHidden(): Flow<PageEvent.InterstitialHidden> = interstitialHiddenEvents()

  /**
   * Fired when interstitial page was shown
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-interstitialShown)
   */
  public fun interstitialShownEvents(): Flow<PageEvent.InterstitialShown> =
      session.typedEvents("Page.interstitialShown")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("interstitialShownEvents()"),
  )
  public fun interstitialShown(): Flow<PageEvent.InterstitialShown> = interstitialShownEvents()

  /**
   * Fired when a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload) has been
   * closed.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-javascriptDialogClosed)
   */
  public fun javascriptDialogClosedEvents(): Flow<PageEvent.JavascriptDialogClosed> =
      session.typedEvents("Page.javascriptDialogClosed")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("javascriptDialogClosedEvents()"),
  )
  public fun javascriptDialogClosed(): Flow<PageEvent.JavascriptDialogClosed> =
      javascriptDialogClosedEvents()

  /**
   * Fired when a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload) is about
   * to
   * open.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-javascriptDialogOpening)
   */
  public fun javascriptDialogOpeningEvents(): Flow<PageEvent.JavascriptDialogOpening> =
      session.typedEvents("Page.javascriptDialogOpening")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("javascriptDialogOpeningEvents()"),
  )
  public fun javascriptDialogOpening(): Flow<PageEvent.JavascriptDialogOpening> =
      javascriptDialogOpeningEvents()

  /**
   * Fired for top level page lifecycle events such as navigation, load, paint, etc.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-lifecycleEvent)
   */
  public fun lifecycleEventEvents(): Flow<PageEvent.LifecycleEvent> =
      session.typedEvents("Page.lifecycleEvent")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("lifecycleEventEvents()"),
  )
  public fun lifecycleEvent(): Flow<PageEvent.LifecycleEvent> = lifecycleEventEvents()

  /**
   * Fired for failed bfcache history navigations if BackForwardCache feature is enabled. Do
   * not assume any ordering with the Page.frameNavigated event. This event is fired only for
   * main-frame history navigation where the document changes (non-same-document navigations),
   * when bfcache navigation fails.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-backForwardCacheNotUsed)
   */
  @ExperimentalChromeApi
  public fun backForwardCacheNotUsedEvents(): Flow<PageEvent.BackForwardCacheNotUsed> =
      session.typedEvents("Page.backForwardCacheNotUsed")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("backForwardCacheNotUsedEvents()"),
  )
  public fun backForwardCacheNotUsed(): Flow<PageEvent.BackForwardCacheNotUsed> =
      backForwardCacheNotUsedEvents()

  /**
   * Fired when a prerender attempt is completed.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-prerenderAttemptCompleted)
   */
  @ExperimentalChromeApi
  public fun prerenderAttemptCompletedEvents(): Flow<PageEvent.PrerenderAttemptCompleted> =
      session.typedEvents("Page.prerenderAttemptCompleted")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("prerenderAttemptCompletedEvents()"),
  )
  public fun prerenderAttemptCompleted(): Flow<PageEvent.PrerenderAttemptCompleted> =
      prerenderAttemptCompletedEvents()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-loadEventFired)
   */
  public fun loadEventFiredEvents(): Flow<PageEvent.LoadEventFired> =
      session.typedEvents("Page.loadEventFired")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("loadEventFiredEvents()"),
  )
  public fun loadEventFired(): Flow<PageEvent.LoadEventFired> = loadEventFiredEvents()

  /**
   * Fired when same-document navigation happens, e.g. due to history API usage or anchor
   * navigation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-navigatedWithinDocument)
   */
  @ExperimentalChromeApi
  public fun navigatedWithinDocumentEvents(): Flow<PageEvent.NavigatedWithinDocument> =
      session.typedEvents("Page.navigatedWithinDocument")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("navigatedWithinDocumentEvents()"),
  )
  public fun navigatedWithinDocument(): Flow<PageEvent.NavigatedWithinDocument> =
      navigatedWithinDocumentEvents()

  /**
   * Compressed image data requested by the `startScreencast`.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-screencastFrame)
   */
  @ExperimentalChromeApi
  public fun screencastFrameEvents(): Flow<PageEvent.ScreencastFrame> =
      session.typedEvents("Page.screencastFrame")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("screencastFrameEvents()"),
  )
  public fun screencastFrame(): Flow<PageEvent.ScreencastFrame> = screencastFrameEvents()

  /**
   * Fired when the page with currently enabled screencast was shown or hidden `.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-screencastVisibilityChanged)
   */
  @ExperimentalChromeApi
  public fun screencastVisibilityChangedEvents(): Flow<PageEvent.ScreencastVisibilityChanged> =
      session.typedEvents("Page.screencastVisibilityChanged")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("screencastVisibilityChangedEvents()"),
  )
  public fun screencastVisibilityChanged(): Flow<PageEvent.ScreencastVisibilityChanged> =
      screencastVisibilityChangedEvents()

  /**
   * Fired when a new window is going to be opened, via window.open(), link click, form submission,
   * etc.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-windowOpen)
   */
  public fun windowOpenEvents(): Flow<PageEvent.WindowOpen> = session.typedEvents("Page.windowOpen")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("windowOpenEvents()"),
  )
  public fun windowOpen(): Flow<PageEvent.WindowOpen> = windowOpenEvents()

  /**
   * Issued for every compilation cache generated. Is only available
   * if Page.setGenerateCompilationCache is enabled.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#event-compilationCacheProduced)
   */
  @ExperimentalChromeApi
  public fun compilationCacheProducedEvents(): Flow<PageEvent.CompilationCacheProduced> =
      session.typedEvents("Page.compilationCacheProduced")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("compilationCacheProducedEvents()"),
  )
  public fun compilationCacheProduced(): Flow<PageEvent.CompilationCacheProduced> =
      compilationCacheProducedEvents()

  /**
   * Deprecated, please use addScriptToEvaluateOnNewDocument instead.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-addScriptToEvaluateOnLoad)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun addScriptToEvaluateOnLoad(input: AddScriptToEvaluateOnLoadRequest):
      AddScriptToEvaluateOnLoadResponse = session.request("Page.addScriptToEvaluateOnLoad", input)

  /**
   * Deprecated, please use addScriptToEvaluateOnNewDocument instead.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-addScriptToEvaluateOnLoad)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun addScriptToEvaluateOnLoad(scriptSource: String):
      AddScriptToEvaluateOnLoadResponse {
    val input = AddScriptToEvaluateOnLoadRequest(scriptSource)
    return addScriptToEvaluateOnLoad(input)
  }

  /**
   * Evaluates given script in every frame upon creation (before loading frame's scripts).
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-addScriptToEvaluateOnNewDocument)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend
      fun addScriptToEvaluateOnNewDocument(input: AddScriptToEvaluateOnNewDocumentRequest):
      AddScriptToEvaluateOnNewDocumentResponse =
      session.request("Page.addScriptToEvaluateOnNewDocument", input)

  /**
   * Evaluates given script in every frame upon creation (before loading frame's scripts).
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-addScriptToEvaluateOnNewDocument)
   */
  @JvmOverloads
  public suspend inline fun addScriptToEvaluateOnNewDocument(source: String,
      optionalArgs: AddScriptToEvaluateOnNewDocumentRequest.Builder.() -> Unit = {}):
      AddScriptToEvaluateOnNewDocumentResponse {
    val builder = AddScriptToEvaluateOnNewDocumentRequest.Builder(source)
    val input = builder.apply(optionalArgs).build()
    return addScriptToEvaluateOnNewDocument(input)
  }

  /**
   * Brings page to front (activates tab).
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-bringToFront)
   */
  public suspend fun bringToFront(): BringToFrontResponse = session.request("Page.bringToFront",
      Unit)

  /**
   * Capture page screenshot.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-captureScreenshot)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun captureScreenshot(input: CaptureScreenshotRequest): CaptureScreenshotResponse =
      session.request("Page.captureScreenshot", input)

  /**
   * Capture page screenshot.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-captureScreenshot)
   */
  @JvmOverloads
  public suspend inline
      fun captureScreenshot(optionalArgs: CaptureScreenshotRequest.Builder.() -> Unit = {}):
      CaptureScreenshotResponse {
    val builder = CaptureScreenshotRequest.Builder()
    val input = builder.apply(optionalArgs).build()
    return captureScreenshot(input)
  }

  /**
   * Returns a snapshot of the page as a string. For MHTML format, the serialization includes
   * iframes, shadow DOM, external resources, and element-inline styles.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-captureSnapshot)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun captureSnapshot(input: CaptureSnapshotRequest): CaptureSnapshotResponse =
      session.request("Page.captureSnapshot", input)

  /**
   * Returns a snapshot of the page as a string. For MHTML format, the serialization includes
   * iframes, shadow DOM, external resources, and element-inline styles.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-captureSnapshot)
   */
  @ExperimentalChromeApi
  @JvmOverloads
  public suspend inline fun captureSnapshot(optionalArgs: CaptureSnapshotRequest.Builder.() -> Unit
      = {}): CaptureSnapshotResponse {
    val builder = CaptureSnapshotRequest.Builder()
    val input = builder.apply(optionalArgs).build()
    return captureSnapshot(input)
  }

  /**
   * Clears the overridden device metrics.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-clearDeviceMetricsOverride)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun clearDeviceMetricsOverride(): ClearDeviceMetricsOverrideResponse =
      session.request("Page.clearDeviceMetricsOverride", Unit)

  /**
   * Clears the overridden Device Orientation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-clearDeviceOrientationOverride)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun clearDeviceOrientationOverride(): ClearDeviceOrientationOverrideResponse =
      session.request("Page.clearDeviceOrientationOverride", Unit)

  /**
   * Clears the overridden Geolocation Position and Error.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-clearGeolocationOverride)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public suspend fun clearGeolocationOverride(): ClearGeolocationOverrideResponse =
      session.request("Page.clearGeolocationOverride", Unit)

  /**
   * Creates an isolated world for the given frame.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-createIsolatedWorld)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun createIsolatedWorld(input: CreateIsolatedWorldRequest):
      CreateIsolatedWorldResponse = session.request("Page.createIsolatedWorld", input)

  /**
   * Creates an isolated world for the given frame.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-createIsolatedWorld)
   *
   * @param frameId Id of the frame in which the isolated world should be created.
   */
  @JvmOverloads
  public suspend inline fun createIsolatedWorld(frameId: FrameId,
      optionalArgs: CreateIsolatedWorldRequest.Builder.() -> Unit = {}):
      CreateIsolatedWorldResponse {
    val builder = CreateIsolatedWorldRequest.Builder(frameId)
    val input = builder.apply(optionalArgs).build()
    return createIsolatedWorld(input)
  }

  /**
   * Deletes browser cookie with given name, domain and path.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-deleteCookie)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun deleteCookie(input: DeleteCookieRequest): DeleteCookieResponse =
      session.request("Page.deleteCookie", input)

  /**
   * Deletes browser cookie with given name, domain and path.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-deleteCookie)
   *
   * @param cookieName Name of the cookie to remove.
   * @param url URL to match cooke domain and path.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun deleteCookie(cookieName: String, url: String): DeleteCookieResponse {
    val input = DeleteCookieRequest(cookieName, url)
    return deleteCookie(input)
  }

  /**
   * Disables page domain notifications.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-disable)
   */
  public suspend fun disable(): DisableResponse = session.request("Page.disable", Unit)

  /**
   * Enables page domain notifications.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-enable)
   */
  public suspend fun enable(): EnableResponse = session.request("Page.enable", Unit)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getAppManifest)
   */
  public suspend fun getAppManifest(): GetAppManifestResponse =
      session.request("Page.getAppManifest", Unit)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getInstallabilityErrors)
   */
  @ExperimentalChromeApi
  public suspend fun getInstallabilityErrors(): GetInstallabilityErrorsResponse =
      session.request("Page.getInstallabilityErrors", Unit)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getManifestIcons)
   */
  @ExperimentalChromeApi
  public suspend fun getManifestIcons(): GetManifestIconsResponse =
      session.request("Page.getManifestIcons", Unit)

  /**
   * Returns the unique (PWA) app id.
   * Only returns values if the feature flag 'WebAppEnableManifestId' is enabled
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getAppId)
   */
  @ExperimentalChromeApi
  public suspend fun getAppId(): GetAppIdResponse = session.request("Page.getAppId", Unit)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getAdScriptId)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun getAdScriptId(input: GetAdScriptIdRequest): GetAdScriptIdResponse =
      session.request("Page.getAdScriptId", input)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getAdScriptId)
   */
  @ExperimentalChromeApi
  public suspend fun getAdScriptId(frameId: FrameId): GetAdScriptIdResponse {
    val input = GetAdScriptIdRequest(frameId)
    return getAdScriptId(input)
  }

  /**
   * Returns all browser cookies for the page and all of its subframes. Depending
   * on the backend support, will return detailed cookie information in the
   * `cookies` field.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getCookies)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun getCookies(): GetCookiesResponse = session.request("Page.getCookies", Unit)

  /**
   * Returns present frame tree structure.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getFrameTree)
   */
  public suspend fun getFrameTree(): GetFrameTreeResponse = session.request("Page.getFrameTree",
      Unit)

  /**
   * Returns metrics relating to the layouting of the page, such as viewport bounds/scale.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getLayoutMetrics)
   */
  public suspend fun getLayoutMetrics(): GetLayoutMetricsResponse =
      session.request("Page.getLayoutMetrics", Unit)

  /**
   * Returns navigation history for the current page.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getNavigationHistory)
   */
  public suspend fun getNavigationHistory(): GetNavigationHistoryResponse =
      session.request("Page.getNavigationHistory", Unit)

  /**
   * Resets navigation history for the current page.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-resetNavigationHistory)
   */
  public suspend fun resetNavigationHistory(): ResetNavigationHistoryResponse =
      session.request("Page.resetNavigationHistory", Unit)

  /**
   * Returns content of the given resource.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getResourceContent)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun getResourceContent(input: GetResourceContentRequest):
      GetResourceContentResponse = session.request("Page.getResourceContent", input)

  /**
   * Returns content of the given resource.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getResourceContent)
   *
   * @param frameId Frame id to get resource for.
   * @param url URL of the resource to get content for.
   */
  @ExperimentalChromeApi
  public suspend fun getResourceContent(frameId: FrameId, url: String): GetResourceContentResponse {
    val input = GetResourceContentRequest(frameId, url)
    return getResourceContent(input)
  }

  /**
   * Returns present frame / resource tree structure.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getResourceTree)
   */
  @ExperimentalChromeApi
  public suspend fun getResourceTree(): GetResourceTreeResponse =
      session.request("Page.getResourceTree", Unit)

  /**
   * Accepts or dismisses a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload).
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-handleJavaScriptDialog)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun handleJavaScriptDialog(input: HandleJavaScriptDialogRequest):
      HandleJavaScriptDialogResponse = session.request("Page.handleJavaScriptDialog", input)

  /**
   * Accepts or dismisses a JavaScript initiated dialog (alert, confirm, prompt, or onbeforeunload).
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-handleJavaScriptDialog)
   *
   * @param accept Whether to accept or dismiss the dialog.
   */
  @JvmOverloads
  public suspend inline fun handleJavaScriptDialog(accept: Boolean,
      optionalArgs: HandleJavaScriptDialogRequest.Builder.() -> Unit = {}):
      HandleJavaScriptDialogResponse {
    val builder = HandleJavaScriptDialogRequest.Builder(accept)
    val input = builder.apply(optionalArgs).build()
    return handleJavaScriptDialog(input)
  }

  /**
   * Navigates current page to the given URL.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-navigate)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun navigate(input: NavigateRequest): NavigateResponse =
      session.request("Page.navigate", input)

  /**
   * Navigates current page to the given URL.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-navigate)
   *
   * @param url URL to navigate the page to.
   */
  @JvmOverloads
  public suspend inline fun navigate(url: String, optionalArgs: NavigateRequest.Builder.() -> Unit =
      {}): NavigateResponse {
    val builder = NavigateRequest.Builder(url)
    val input = builder.apply(optionalArgs).build()
    return navigate(input)
  }

  /**
   * Navigates current page to the given history entry.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-navigateToHistoryEntry)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun navigateToHistoryEntry(input: NavigateToHistoryEntryRequest):
      NavigateToHistoryEntryResponse = session.request("Page.navigateToHistoryEntry", input)

  /**
   * Navigates current page to the given history entry.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-navigateToHistoryEntry)
   *
   * @param entryId Unique id of the entry to navigate to.
   */
  public suspend fun navigateToHistoryEntry(entryId: Int): NavigateToHistoryEntryResponse {
    val input = NavigateToHistoryEntryRequest(entryId)
    return navigateToHistoryEntry(input)
  }

  /**
   * Print page as PDF.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-printToPDF)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun printToPDF(input: PrintToPDFRequest): PrintToPDFResponse =
      session.request("Page.printToPDF", input)

  /**
   * Print page as PDF.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-printToPDF)
   */
  @JvmOverloads
  public suspend inline fun printToPDF(optionalArgs: PrintToPDFRequest.Builder.() -> Unit = {}):
      PrintToPDFResponse {
    val builder = PrintToPDFRequest.Builder()
    val input = builder.apply(optionalArgs).build()
    return printToPDF(input)
  }

  /**
   * Reloads given page optionally ignoring the cache.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-reload)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun reload(input: ReloadRequest): ReloadResponse = session.request("Page.reload",
      input)

  /**
   * Reloads given page optionally ignoring the cache.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-reload)
   */
  @JvmOverloads
  public suspend inline fun reload(optionalArgs: ReloadRequest.Builder.() -> Unit = {}):
      ReloadResponse {
    val builder = ReloadRequest.Builder()
    val input = builder.apply(optionalArgs).build()
    return reload(input)
  }

  /**
   * Deprecated, please use removeScriptToEvaluateOnNewDocument instead.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-removeScriptToEvaluateOnLoad)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun removeScriptToEvaluateOnLoad(input: RemoveScriptToEvaluateOnLoadRequest):
      RemoveScriptToEvaluateOnLoadResponse = session.request("Page.removeScriptToEvaluateOnLoad",
      input)

  /**
   * Deprecated, please use removeScriptToEvaluateOnNewDocument instead.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-removeScriptToEvaluateOnLoad)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun removeScriptToEvaluateOnLoad(identifier: ScriptIdentifier):
      RemoveScriptToEvaluateOnLoadResponse {
    val input = RemoveScriptToEvaluateOnLoadRequest(identifier)
    return removeScriptToEvaluateOnLoad(input)
  }

  /**
   * Removes given script from the list.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-removeScriptToEvaluateOnNewDocument)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend
      fun removeScriptToEvaluateOnNewDocument(input: RemoveScriptToEvaluateOnNewDocumentRequest):
      RemoveScriptToEvaluateOnNewDocumentResponse =
      session.request("Page.removeScriptToEvaluateOnNewDocument", input)

  /**
   * Removes given script from the list.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-removeScriptToEvaluateOnNewDocument)
   */
  public suspend fun removeScriptToEvaluateOnNewDocument(identifier: ScriptIdentifier):
      RemoveScriptToEvaluateOnNewDocumentResponse {
    val input = RemoveScriptToEvaluateOnNewDocumentRequest(identifier)
    return removeScriptToEvaluateOnNewDocument(input)
  }

  /**
   * Acknowledges that a screencast frame has been received by the frontend.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-screencastFrameAck)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun screencastFrameAck(input: ScreencastFrameAckRequest):
      ScreencastFrameAckResponse = session.request("Page.screencastFrameAck", input)

  /**
   * Acknowledges that a screencast frame has been received by the frontend.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-screencastFrameAck)
   *
   * @param sessionId Frame number.
   */
  @ExperimentalChromeApi
  public suspend fun screencastFrameAck(sessionId: Int): ScreencastFrameAckResponse {
    val input = ScreencastFrameAckRequest(sessionId)
    return screencastFrameAck(input)
  }

  /**
   * Searches for given string in resource content.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-searchInResource)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun searchInResource(input: SearchInResourceRequest): SearchInResourceResponse =
      session.request("Page.searchInResource", input)

  /**
   * Searches for given string in resource content.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-searchInResource)
   *
   * @param frameId Frame id for resource to search in.
   * @param url URL of the resource to search in.
   * @param query String to search for.
   */
  @ExperimentalChromeApi
  @JvmOverloads
  public suspend inline fun searchInResource(
    frameId: FrameId,
    url: String,
    query: String,
    optionalArgs: SearchInResourceRequest.Builder.() -> Unit = {},
  ): SearchInResourceResponse {
    val builder = SearchInResourceRequest.Builder(frameId, url, query)
    val input = builder.apply(optionalArgs).build()
    return searchInResource(input)
  }

  /**
   * Enable Chrome's experimental ad filter on all sites.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setAdBlockingEnabled)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun setAdBlockingEnabled(input: SetAdBlockingEnabledRequest):
      SetAdBlockingEnabledResponse = session.request("Page.setAdBlockingEnabled", input)

  /**
   * Enable Chrome's experimental ad filter on all sites.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setAdBlockingEnabled)
   *
   * @param enabled Whether to block ads.
   */
  @ExperimentalChromeApi
  public suspend fun setAdBlockingEnabled(enabled: Boolean): SetAdBlockingEnabledResponse {
    val input = SetAdBlockingEnabledRequest(enabled)
    return setAdBlockingEnabled(input)
  }

  /**
   * Enable page Content Security Policy by-passing.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setBypassCSP)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun setBypassCSP(input: SetBypassCSPRequest): SetBypassCSPResponse =
      session.request("Page.setBypassCSP", input)

  /**
   * Enable page Content Security Policy by-passing.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setBypassCSP)
   *
   * @param enabled Whether to bypass page CSP.
   */
  @ExperimentalChromeApi
  public suspend fun setBypassCSP(enabled: Boolean): SetBypassCSPResponse {
    val input = SetBypassCSPRequest(enabled)
    return setBypassCSP(input)
  }

  /**
   * Get Permissions Policy state on given frame.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getPermissionsPolicyState)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun getPermissionsPolicyState(input: GetPermissionsPolicyStateRequest):
      GetPermissionsPolicyStateResponse = session.request("Page.getPermissionsPolicyState", input)

  /**
   * Get Permissions Policy state on given frame.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getPermissionsPolicyState)
   */
  @ExperimentalChromeApi
  public suspend fun getPermissionsPolicyState(frameId: FrameId):
      GetPermissionsPolicyStateResponse {
    val input = GetPermissionsPolicyStateRequest(frameId)
    return getPermissionsPolicyState(input)
  }

  /**
   * Get Origin Trials on given frame.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getOriginTrials)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun getOriginTrials(input: GetOriginTrialsRequest): GetOriginTrialsResponse =
      session.request("Page.getOriginTrials", input)

  /**
   * Get Origin Trials on given frame.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-getOriginTrials)
   */
  @ExperimentalChromeApi
  public suspend fun getOriginTrials(frameId: FrameId): GetOriginTrialsResponse {
    val input = GetOriginTrialsRequest(frameId)
    return getOriginTrials(input)
  }

  /**
   * Overrides the values of device screen dimensions (window.screen.width, window.screen.height,
   * window.innerWidth, window.innerHeight, and "device-width"/"device-height"-related CSS media
   * query results).
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setDeviceMetricsOverride)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun setDeviceMetricsOverride(input: SetDeviceMetricsOverrideRequest):
      SetDeviceMetricsOverrideResponse = session.request("Page.setDeviceMetricsOverride", input)

  /**
   * Overrides the values of device screen dimensions (window.screen.width, window.screen.height,
   * window.innerWidth, window.innerHeight, and "device-width"/"device-height"-related CSS media
   * query results).
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setDeviceMetricsOverride)
   *
   * @param width Overriding width value in pixels (minimum 0, maximum 10000000). 0 disables the
   * override.
   * @param height Overriding height value in pixels (minimum 0, maximum 10000000). 0 disables the
   * override.
   * @param deviceScaleFactor Overriding device scale factor value. 0 disables the override.
   * @param mobile Whether to emulate mobile device. This includes viewport meta tag, overlay
   * scrollbars, text
   * autosizing and more.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  @JvmOverloads
  public suspend inline fun setDeviceMetricsOverride(
    width: Int,
    height: Int,
    deviceScaleFactor: Double,
    mobile: Boolean,
    optionalArgs: SetDeviceMetricsOverrideRequest.Builder.() -> Unit = {},
  ): SetDeviceMetricsOverrideResponse {
    val builder = SetDeviceMetricsOverrideRequest.Builder(width, height, deviceScaleFactor, mobile)
    val input = builder.apply(optionalArgs).build()
    return setDeviceMetricsOverride(input)
  }

  /**
   * Overrides the Device Orientation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setDeviceOrientationOverride)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun setDeviceOrientationOverride(input: SetDeviceOrientationOverrideRequest):
      SetDeviceOrientationOverrideResponse = session.request("Page.setDeviceOrientationOverride",
      input)

  /**
   * Overrides the Device Orientation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setDeviceOrientationOverride)
   *
   * @param alpha Mock alpha
   * @param beta Mock beta
   * @param gamma Mock gamma
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun setDeviceOrientationOverride(
    alpha: Double,
    beta: Double,
    gamma: Double,
  ): SetDeviceOrientationOverrideResponse {
    val input = SetDeviceOrientationOverrideRequest(alpha, beta, gamma)
    return setDeviceOrientationOverride(input)
  }

  /**
   * Set generic font families.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setFontFamilies)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun setFontFamilies(input: SetFontFamiliesRequest): SetFontFamiliesResponse =
      session.request("Page.setFontFamilies", input)

  /**
   * Set generic font families.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setFontFamilies)
   *
   * @param fontFamilies Specifies font families to set. If a font family is not specified, it won't
   * be changed.
   */
  @ExperimentalChromeApi
  @JvmOverloads
  public suspend inline fun setFontFamilies(fontFamilies: FontFamilies,
      optionalArgs: SetFontFamiliesRequest.Builder.() -> Unit = {}): SetFontFamiliesResponse {
    val builder = SetFontFamiliesRequest.Builder(fontFamilies)
    val input = builder.apply(optionalArgs).build()
    return setFontFamilies(input)
  }

  /**
   * Set default font sizes.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setFontSizes)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun setFontSizes(input: SetFontSizesRequest): SetFontSizesResponse =
      session.request("Page.setFontSizes", input)

  /**
   * Set default font sizes.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setFontSizes)
   *
   * @param fontSizes Specifies font sizes to set. If a font size is not specified, it won't be
   * changed.
   */
  @ExperimentalChromeApi
  public suspend fun setFontSizes(fontSizes: FontSizes): SetFontSizesResponse {
    val input = SetFontSizesRequest(fontSizes)
    return setFontSizes(input)
  }

  /**
   * Sets given markup as the document's HTML.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setDocumentContent)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun setDocumentContent(input: SetDocumentContentRequest):
      SetDocumentContentResponse = session.request("Page.setDocumentContent", input)

  /**
   * Sets given markup as the document's HTML.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setDocumentContent)
   *
   * @param frameId Frame id to set HTML for.
   * @param html HTML content to set.
   */
  public suspend fun setDocumentContent(frameId: FrameId, html: String):
      SetDocumentContentResponse {
    val input = SetDocumentContentRequest(frameId, html)
    return setDocumentContent(input)
  }

  /**
   * Set the behavior when downloading a file.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setDownloadBehavior)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun setDownloadBehavior(input: SetDownloadBehaviorRequest):
      SetDownloadBehaviorResponse = session.request("Page.setDownloadBehavior", input)

  /**
   * Set the behavior when downloading a file.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setDownloadBehavior)
   *
   * @param behavior Whether to allow all or deny all download requests, or use default Chrome
   * behavior if
   * available (otherwise deny).
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  @JvmOverloads
  public suspend inline fun setDownloadBehavior(behavior: DownloadBehavior,
      optionalArgs: SetDownloadBehaviorRequest.Builder.() -> Unit = {}):
      SetDownloadBehaviorResponse {
    val builder = SetDownloadBehaviorRequest.Builder(behavior)
    val input = builder.apply(optionalArgs).build()
    return setDownloadBehavior(input)
  }

  /**
   * Overrides the Geolocation Position or Error. Omitting any of the parameters emulates position
   * unavailable.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setGeolocationOverride)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  public suspend fun setGeolocationOverride(input: SetGeolocationOverrideRequest):
      SetGeolocationOverrideResponse = session.request("Page.setGeolocationOverride", input)

  /**
   * Overrides the Geolocation Position or Error. Omitting any of the parameters emulates position
   * unavailable.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setGeolocationOverride)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @JvmOverloads
  public suspend inline
      fun setGeolocationOverride(optionalArgs: SetGeolocationOverrideRequest.Builder.() -> Unit =
      {}): SetGeolocationOverrideResponse {
    val builder = SetGeolocationOverrideRequest.Builder()
    val input = builder.apply(optionalArgs).build()
    return setGeolocationOverride(input)
  }

  /**
   * Controls whether page will emit lifecycle events.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setLifecycleEventsEnabled)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun setLifecycleEventsEnabled(input: SetLifecycleEventsEnabledRequest):
      SetLifecycleEventsEnabledResponse = session.request("Page.setLifecycleEventsEnabled", input)

  /**
   * Controls whether page will emit lifecycle events.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setLifecycleEventsEnabled)
   *
   * @param enabled If true, starts emitting lifecycle events.
   */
  @ExperimentalChromeApi
  public suspend fun setLifecycleEventsEnabled(enabled: Boolean):
      SetLifecycleEventsEnabledResponse {
    val input = SetLifecycleEventsEnabledRequest(enabled)
    return setLifecycleEventsEnabled(input)
  }

  /**
   * Toggles mouse event-based touch event emulation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setTouchEmulationEnabled)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  public suspend fun setTouchEmulationEnabled(input: SetTouchEmulationEnabledRequest):
      SetTouchEmulationEnabledResponse = session.request("Page.setTouchEmulationEnabled", input)

  /**
   * Toggles mouse event-based touch event emulation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setTouchEmulationEnabled)
   *
   * @param enabled Whether the touch event emulation should be enabled.
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @ExperimentalChromeApi
  @JvmOverloads
  public suspend inline fun setTouchEmulationEnabled(enabled: Boolean,
      optionalArgs: SetTouchEmulationEnabledRequest.Builder.() -> Unit = {}):
      SetTouchEmulationEnabledResponse {
    val builder = SetTouchEmulationEnabledRequest.Builder(enabled)
    val input = builder.apply(optionalArgs).build()
    return setTouchEmulationEnabled(input)
  }

  /**
   * Starts sending each frame using the `screencastFrame` event.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-startScreencast)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun startScreencast(input: StartScreencastRequest): StartScreencastResponse =
      session.request("Page.startScreencast", input)

  /**
   * Starts sending each frame using the `screencastFrame` event.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-startScreencast)
   */
  @ExperimentalChromeApi
  @JvmOverloads
  public suspend inline fun startScreencast(optionalArgs: StartScreencastRequest.Builder.() -> Unit
      = {}): StartScreencastResponse {
    val builder = StartScreencastRequest.Builder()
    val input = builder.apply(optionalArgs).build()
    return startScreencast(input)
  }

  /**
   * Force the page stop all navigations and pending resource fetches.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-stopLoading)
   */
  public suspend fun stopLoading(): StopLoadingResponse = session.request("Page.stopLoading", Unit)

  /**
   * Crashes renderer on the IO thread, generates minidumps.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-crash)
   */
  @ExperimentalChromeApi
  public suspend fun crash(): CrashResponse = session.request("Page.crash", Unit)

  /**
   * Tries to close page, running its beforeunload hooks, if any.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-close)
   */
  @ExperimentalChromeApi
  public suspend fun close(): CloseResponse = session.request("Page.close", Unit)

  /**
   * Tries to update the web lifecycle state of the page.
   * It will transition the page to the given state according to:
   * https://github.com/WICG/web-lifecycle/
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setWebLifecycleState)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun setWebLifecycleState(input: SetWebLifecycleStateRequest):
      SetWebLifecycleStateResponse = session.request("Page.setWebLifecycleState", input)

  /**
   * Tries to update the web lifecycle state of the page.
   * It will transition the page to the given state according to:
   * https://github.com/WICG/web-lifecycle/
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setWebLifecycleState)
   *
   * @param state Target lifecycle state
   */
  @ExperimentalChromeApi
  public suspend fun setWebLifecycleState(state: WebLifecycleState): SetWebLifecycleStateResponse {
    val input = SetWebLifecycleStateRequest(state)
    return setWebLifecycleState(input)
  }

  /**
   * Stops sending each frame in the `screencastFrame`.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-stopScreencast)
   */
  @ExperimentalChromeApi
  public suspend fun stopScreencast(): StopScreencastResponse =
      session.request("Page.stopScreencast", Unit)

  /**
   * Requests backend to produce compilation cache for the specified scripts.
   * `scripts` are appeneded to the list of scripts for which the cache
   * would be produced. The list may be reset during page navigation.
   * When script with a matching URL is encountered, the cache is optionally
   * produced upon backend discretion, based on internal heuristics.
   * See also: `Page.compilationCacheProduced`.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-produceCompilationCache)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun produceCompilationCache(input: ProduceCompilationCacheRequest):
      ProduceCompilationCacheResponse = session.request("Page.produceCompilationCache", input)

  /**
   * Requests backend to produce compilation cache for the specified scripts.
   * `scripts` are appeneded to the list of scripts for which the cache
   * would be produced. The list may be reset during page navigation.
   * When script with a matching URL is encountered, the cache is optionally
   * produced upon backend discretion, based on internal heuristics.
   * See also: `Page.compilationCacheProduced`.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-produceCompilationCache)
   */
  @ExperimentalChromeApi
  public suspend fun produceCompilationCache(scripts: List<CompilationCacheParams>):
      ProduceCompilationCacheResponse {
    val input = ProduceCompilationCacheRequest(scripts)
    return produceCompilationCache(input)
  }

  /**
   * Seeds compilation cache for given url. Compilation cache does not survive
   * cross-process navigation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-addCompilationCache)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun addCompilationCache(input: AddCompilationCacheRequest):
      AddCompilationCacheResponse = session.request("Page.addCompilationCache", input)

  /**
   * Seeds compilation cache for given url. Compilation cache does not survive
   * cross-process navigation.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-addCompilationCache)
   * @param data Base64-encoded data (Encoded as a base64 string when passed over JSON)
   */
  @ExperimentalChromeApi
  public suspend fun addCompilationCache(url: String, `data`: String): AddCompilationCacheResponse {
    val input = AddCompilationCacheRequest(url, data)
    return addCompilationCache(input)
  }

  /**
   * Clears seeded compilation cache.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-clearCompilationCache)
   */
  @ExperimentalChromeApi
  public suspend fun clearCompilationCache(): ClearCompilationCacheResponse =
      session.request("Page.clearCompilationCache", Unit)

  /**
   * Sets the Secure Payment Confirmation transaction mode.
   * https://w3c.github.io/secure-payment-confirmation/#sctn-automation-set-spc-transaction-mode
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setSPCTransactionMode)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun setSPCTransactionMode(input: SetSPCTransactionModeRequest):
      SetSPCTransactionModeResponse = session.request("Page.setSPCTransactionMode", input)

  /**
   * Sets the Secure Payment Confirmation transaction mode.
   * https://w3c.github.io/secure-payment-confirmation/#sctn-automation-set-spc-transaction-mode
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setSPCTransactionMode)
   */
  @ExperimentalChromeApi
  public suspend fun setSPCTransactionMode(mode: SPCTransactionMode):
      SetSPCTransactionModeResponse {
    val input = SetSPCTransactionModeRequest(mode)
    return setSPCTransactionMode(input)
  }

  /**
   * Generates a report for testing.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-generateTestReport)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun generateTestReport(input: GenerateTestReportRequest):
      GenerateTestReportResponse = session.request("Page.generateTestReport", input)

  /**
   * Generates a report for testing.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-generateTestReport)
   *
   * @param message Message to be displayed in the report.
   */
  @ExperimentalChromeApi
  @JvmOverloads
  public suspend inline fun generateTestReport(message: String,
      optionalArgs: GenerateTestReportRequest.Builder.() -> Unit = {}): GenerateTestReportResponse {
    val builder = GenerateTestReportRequest.Builder(message)
    val input = builder.apply(optionalArgs).build()
    return generateTestReport(input)
  }

  /**
   * Pauses page execution. Can be resumed using generic Runtime.runIfWaitingForDebugger.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-waitForDebugger)
   */
  @ExperimentalChromeApi
  public suspend fun waitForDebugger(): WaitForDebuggerResponse =
      session.request("Page.waitForDebugger", Unit)

  /**
   * Intercept file chooser requests and transfer control to protocol clients.
   * When file chooser interception is enabled, native file chooser dialog is not shown.
   * Instead, a protocol event `Page.fileChooserOpened` is emitted.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setInterceptFileChooserDialog)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  @ExperimentalChromeApi
  public suspend fun setInterceptFileChooserDialog(input: SetInterceptFileChooserDialogRequest):
      SetInterceptFileChooserDialogResponse = session.request("Page.setInterceptFileChooserDialog",
      input)

  /**
   * Intercept file chooser requests and transfer control to protocol clients.
   * When file chooser interception is enabled, native file chooser dialog is not shown.
   * Instead, a protocol event `Page.fileChooserOpened` is emitted.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Page/#method-setInterceptFileChooserDialog)
   */
  @ExperimentalChromeApi
  public suspend fun setInterceptFileChooserDialog(enabled: Boolean):
      SetInterceptFileChooserDialogResponse {
    val input = SetInterceptFileChooserDialogRequest(enabled)
    return setInterceptFileChooserDialog(input)
  }
}
