@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.performance

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlinx.serialization.Serializable

/**
 * Run-time execution metric.
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Performance/#type-Metric)
 */
@Serializable
public data class Metric(
  /**
   * Metric name.
   */
  public val name: String,
  /**
   * Metric value.
   */
  public val `value`: Double,
)

/**
 * This enum doesn't have a proper description because it was generated from inline declarations.
 * Its name was inferred based on the places where it is used:
 *  - the parameter 'timeDomain' of the command 'Performance.enable'
 *  - the parameter 'timeDomain' of the command 'Performance.setTimeDomain'
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Performance/#type-TimeDomain)
 */
@Serializable
public enum class TimeDomain {
  timeTicks,
  threadTicks,
}
