@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.performancetimeline.events

import kotlin.Suppress
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.performancetimeline.TimelineEvent

@Serializable
public sealed class PerformanceTimelineEvent {
  /**
   * Sent when a performance timeline event is added. See reportPerformanceTimeline method.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/PerformanceTimeline/#event-timelineEventAdded)
   */
  @Serializable
  public data class TimelineEventAdded(
    public val event: TimelineEvent,
  ) : PerformanceTimelineEvent()
}
