@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.profiler.events

import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.debugger.Location
import org.hildan.chrome.devtools.domains.profiler.Profile
import org.hildan.chrome.devtools.domains.profiler.ScriptCoverage
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

@Serializable
public sealed class ProfilerEvent {
  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#event-consoleProfileFinished)
   */
  @Serializable
  public data class ConsoleProfileFinished(
    public val id: String,
    /**
     * Location of console.profileEnd().
     */
    public val location: Location,
    public val profile: Profile,
    /**
     * Profile title passed as an argument to console.profile().
     */
    public val title: String? = null,
  ) : ProfilerEvent()

  /**
   * Sent when new profile recording is started using console.profile() call.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#event-consoleProfileStarted)
   */
  @Serializable
  public data class ConsoleProfileStarted(
    public val id: String,
    /**
     * Location of console.profile().
     */
    public val location: Location,
    /**
     * Profile title passed as an argument to console.profile().
     */
    public val title: String? = null,
  ) : ProfilerEvent()

  /**
   * Reports coverage delta since the last poll (either from an event like this, or from
   * `takePreciseCoverage` for the current isolate. May only be sent if precise code
   * coverage has been started. This event can be trigged by the embedder to, for example,
   * trigger collection of coverage data immediately at a certain point in time.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Profiler/#event-preciseCoverageDeltaUpdate)
   */
  @ExperimentalChromeApi
  @Serializable
  public data class PreciseCoverageDeltaUpdate(
    /**
     * Monotonically increasing time (in seconds) when the coverage update was taken in the backend.
     */
    public val timestamp: Double,
    /**
     * Identifier for distinguishing coverage events.
     */
    public val occasion: String,
    /**
     * Coverage data for the current isolate.
     */
    public val result: List<ScriptCoverage>,
  ) : ProfilerEvent()
}
