@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.security.events

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlinx.serialization.Serializable
import org.hildan.chrome.devtools.domains.security.InsecureContentStatus
import org.hildan.chrome.devtools.domains.security.SecurityState
import org.hildan.chrome.devtools.domains.security.SecurityStateExplanation
import org.hildan.chrome.devtools.domains.security.VisibleSecurityState
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi

@Serializable
public sealed class SecurityEvent {
  /**
   * There is a certificate error. If overriding certificate errors is enabled, then it should be
   * handled with the `handleCertificateError` command. Note: this event does not fire if the
   * certificate error has been allowed internally. Only one client per target should override
   * certificate errors at the same time.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Security/#event-certificateError)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @Serializable
  public data class CertificateError(
    /**
     * The ID of the event.
     */
    public val eventId: Int,
    /**
     * The type of the error.
     */
    public val errorType: String,
    /**
     * The url that was requested.
     */
    public val requestURL: String,
  ) : SecurityEvent()

  /**
   * The security state of the page changed.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Security/#event-visibleSecurityStateChanged)
   */
  @ExperimentalChromeApi
  @Serializable
  public data class VisibleSecurityStateChanged(
    /**
     * Security state information about the page.
     */
    public val visibleSecurityState: VisibleSecurityState,
  ) : SecurityEvent()

  /**
   * The security state of the page changed. No longer being sent.
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/Security/#event-securityStateChanged)
   */
  @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
  @Serializable
  public data class SecurityStateChanged(
    /**
     * Security state.
     */
    public val securityState: SecurityState,
    /**
     * True if the page was loaded over cryptographic transport such as HTTPS.
     */
    @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
    public val schemeIsCryptographic: Boolean,
    /**
     * Previously a list of explanations for the security state. Now always
     * empty.
     */
    @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
    public val explanations: List<SecurityStateExplanation>,
    /**
     * Information about insecure content on the page.
     */
    @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
    public val insecureContentStatus: InsecureContentStatus,
    /**
     * Overrides user-visible description of the state. Always omitted.
     */
    @Deprecated(message = "Deprecated in the Chrome DevTools protocol")
    public val summary: String? = null,
  ) : SecurityEvent()
}
