@file:Suppress("RedundantVisibilityModifier", "DEPRECATION", "EXPERIMENTAL_API_USAGE")

package org.hildan.chrome.devtools.domains.serviceworker

import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlinx.coroutines.flow.Flow
import kotlinx.serialization.DeserializationStrategy
import kotlinx.serialization.Serializable
import kotlinx.serialization.serializer
import org.hildan.chrome.devtools.domains.serviceworker.events.ServiceWorkerEvent
import org.hildan.chrome.devtools.protocol.ChromeDPSession
import org.hildan.chrome.devtools.protocol.ExperimentalChromeApi
import org.hildan.chrome.devtools.protocol.request
import org.hildan.chrome.devtools.protocol.typedEvents

/**
 * Request object containing input parameters for the [ServiceWorkerDomain.deliverPushMessage]
 * command.
 */
@Serializable
public data class DeliverPushMessageRequest(
  public val origin: String,
  public val registrationId: RegistrationID,
  public val `data`: String,
)

/**
 * A dummy response object for the [ServiceWorkerDomain.deliverPushMessage] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
public object DeliverPushMessageResponse

/**
 * A dummy response object for the [ServiceWorkerDomain.disable] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
public object DisableResponse

/**
 * Request object containing input parameters for the [ServiceWorkerDomain.dispatchSyncEvent]
 * command.
 */
@Serializable
public data class DispatchSyncEventRequest(
  public val origin: String,
  public val registrationId: RegistrationID,
  public val tag: String,
  public val lastChance: Boolean,
)

/**
 * A dummy response object for the [ServiceWorkerDomain.dispatchSyncEvent] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
public object DispatchSyncEventResponse

/**
 * Request object containing input parameters for the
 * [ServiceWorkerDomain.dispatchPeriodicSyncEvent] command.
 */
@Serializable
public data class DispatchPeriodicSyncEventRequest(
  public val origin: String,
  public val registrationId: RegistrationID,
  public val tag: String,
)

/**
 * A dummy response object for the [ServiceWorkerDomain.dispatchPeriodicSyncEvent] command. This
 * command doesn't return any result at the moment, but this could happen in the future, or could have
 * happened in the past. For forwards and backwards compatibility of the command method, we still
 * declare this class even without properties.
 */
@Serializable
public object DispatchPeriodicSyncEventResponse

/**
 * A dummy response object for the [ServiceWorkerDomain.enable] command. This command doesn't return
 * any result at the moment, but this could happen in the future, or could have happened in the past.
 * For forwards and backwards compatibility of the command method, we still declare this class even
 * without properties.
 */
@Serializable
public object EnableResponse

/**
 * Request object containing input parameters for the [ServiceWorkerDomain.inspectWorker] command.
 */
@Serializable
public data class InspectWorkerRequest(
  public val versionId: String,
)

/**
 * A dummy response object for the [ServiceWorkerDomain.inspectWorker] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
public object InspectWorkerResponse

/**
 * Request object containing input parameters for the [ServiceWorkerDomain.setForceUpdateOnPageLoad]
 * command.
 */
@Serializable
public data class SetForceUpdateOnPageLoadRequest(
  public val forceUpdateOnPageLoad: Boolean,
)

/**
 * A dummy response object for the [ServiceWorkerDomain.setForceUpdateOnPageLoad] command. This
 * command doesn't return any result at the moment, but this could happen in the future, or could have
 * happened in the past. For forwards and backwards compatibility of the command method, we still
 * declare this class even without properties.
 */
@Serializable
public object SetForceUpdateOnPageLoadResponse

/**
 * Request object containing input parameters for the [ServiceWorkerDomain.skipWaiting] command.
 */
@Serializable
public data class SkipWaitingRequest(
  public val scopeURL: String,
)

/**
 * A dummy response object for the [ServiceWorkerDomain.skipWaiting] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
public object SkipWaitingResponse

/**
 * Request object containing input parameters for the [ServiceWorkerDomain.startWorker] command.
 */
@Serializable
public data class StartWorkerRequest(
  public val scopeURL: String,
)

/**
 * A dummy response object for the [ServiceWorkerDomain.startWorker] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
public object StartWorkerResponse

/**
 * A dummy response object for the [ServiceWorkerDomain.stopAllWorkers] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
public object StopAllWorkersResponse

/**
 * Request object containing input parameters for the [ServiceWorkerDomain.stopWorker] command.
 */
@Serializable
public data class StopWorkerRequest(
  public val versionId: String,
)

/**
 * A dummy response object for the [ServiceWorkerDomain.stopWorker] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
public object StopWorkerResponse

/**
 * Request object containing input parameters for the [ServiceWorkerDomain.unregister] command.
 */
@Serializable
public data class UnregisterRequest(
  public val scopeURL: String,
)

/**
 * A dummy response object for the [ServiceWorkerDomain.unregister] command. This command doesn't
 * return any result at the moment, but this could happen in the future, or could have happened in the
 * past. For forwards and backwards compatibility of the command method, we still declare this class
 * even without properties.
 */
@Serializable
public object UnregisterResponse

/**
 * Request object containing input parameters for the [ServiceWorkerDomain.updateRegistration]
 * command.
 */
@Serializable
public data class UpdateRegistrationRequest(
  public val scopeURL: String,
)

/**
 * A dummy response object for the [ServiceWorkerDomain.updateRegistration] command. This command
 * doesn't return any result at the moment, but this could happen in the future, or could have happened
 * in the past. For forwards and backwards compatibility of the command method, we still declare this
 * class even without properties.
 */
@Serializable
public object UpdateRegistrationResponse

/**
 *
 *
 * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker)
 */
@ExperimentalChromeApi
public class ServiceWorkerDomain internal constructor(
  private val session: ChromeDPSession,
) {
  /**
   * Mapping between events and their deserializer.
   */
  private val deserializersByEventName: Map<String, DeserializationStrategy<out ServiceWorkerEvent>>
      = mapOf(
      "ServiceWorker.workerErrorReported" to serializer<ServiceWorkerEvent.WorkerErrorReported>(),
      "ServiceWorker.workerRegistrationUpdated" to
          serializer<ServiceWorkerEvent.WorkerRegistrationUpdated>(),
      "ServiceWorker.workerVersionUpdated" to serializer<ServiceWorkerEvent.WorkerVersionUpdated>(),
      )

  /**
   * Subscribes to all events related to this domain.
   */
  public fun events(): Flow<ServiceWorkerEvent> = session.typedEvents(deserializersByEventName)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#event-workerErrorReported)
   */
  public fun workerErrorReportedEvents(): Flow<ServiceWorkerEvent.WorkerErrorReported> =
      session.typedEvents("ServiceWorker.workerErrorReported")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("workerErrorReportedEvents()"),
  )
  public fun workerErrorReported(): Flow<ServiceWorkerEvent.WorkerErrorReported> =
      workerErrorReportedEvents()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#event-workerRegistrationUpdated)
   */
  public fun workerRegistrationUpdatedEvents(): Flow<ServiceWorkerEvent.WorkerRegistrationUpdated> =
      session.typedEvents("ServiceWorker.workerRegistrationUpdated")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("workerRegistrationUpdatedEvents()"),
  )
  public fun workerRegistrationUpdated(): Flow<ServiceWorkerEvent.WorkerRegistrationUpdated> =
      workerRegistrationUpdatedEvents()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#event-workerVersionUpdated)
   */
  public fun workerVersionUpdatedEvents(): Flow<ServiceWorkerEvent.WorkerVersionUpdated> =
      session.typedEvents("ServiceWorker.workerVersionUpdated")

  @Deprecated(
    message = "Events subscription methods were renamed with the -Events suffix.",
    replaceWith = ReplaceWith("workerVersionUpdatedEvents()"),
  )
  public fun workerVersionUpdated(): Flow<ServiceWorkerEvent.WorkerVersionUpdated> =
      workerVersionUpdatedEvents()

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-deliverPushMessage)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun deliverPushMessage(input: DeliverPushMessageRequest):
      DeliverPushMessageResponse = session.request("ServiceWorker.deliverPushMessage", input)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-deliverPushMessage)
   */
  public suspend fun deliverPushMessage(
    origin: String,
    registrationId: RegistrationID,
    `data`: String,
  ): DeliverPushMessageResponse {
    val input = DeliverPushMessageRequest(origin, registrationId, data)
    return deliverPushMessage(input)
  }

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-disable)
   */
  public suspend fun disable(): DisableResponse = session.request("ServiceWorker.disable", Unit)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-dispatchSyncEvent)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun dispatchSyncEvent(input: DispatchSyncEventRequest): DispatchSyncEventResponse =
      session.request("ServiceWorker.dispatchSyncEvent", input)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-dispatchSyncEvent)
   */
  public suspend fun dispatchSyncEvent(
    origin: String,
    registrationId: RegistrationID,
    tag: String,
    lastChance: Boolean,
  ): DispatchSyncEventResponse {
    val input = DispatchSyncEventRequest(origin, registrationId, tag, lastChance)
    return dispatchSyncEvent(input)
  }

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-dispatchPeriodicSyncEvent)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun dispatchPeriodicSyncEvent(input: DispatchPeriodicSyncEventRequest):
      DispatchPeriodicSyncEventResponse = session.request("ServiceWorker.dispatchPeriodicSyncEvent",
      input)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-dispatchPeriodicSyncEvent)
   */
  public suspend fun dispatchPeriodicSyncEvent(
    origin: String,
    registrationId: RegistrationID,
    tag: String,
  ): DispatchPeriodicSyncEventResponse {
    val input = DispatchPeriodicSyncEventRequest(origin, registrationId, tag)
    return dispatchPeriodicSyncEvent(input)
  }

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-enable)
   */
  public suspend fun enable(): EnableResponse = session.request("ServiceWorker.enable", Unit)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-inspectWorker)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun inspectWorker(input: InspectWorkerRequest): InspectWorkerResponse =
      session.request("ServiceWorker.inspectWorker", input)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-inspectWorker)
   */
  public suspend fun inspectWorker(versionId: String): InspectWorkerResponse {
    val input = InspectWorkerRequest(versionId)
    return inspectWorker(input)
  }

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-setForceUpdateOnPageLoad)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun setForceUpdateOnPageLoad(input: SetForceUpdateOnPageLoadRequest):
      SetForceUpdateOnPageLoadResponse = session.request("ServiceWorker.setForceUpdateOnPageLoad",
      input)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-setForceUpdateOnPageLoad)
   */
  public suspend fun setForceUpdateOnPageLoad(forceUpdateOnPageLoad: Boolean):
      SetForceUpdateOnPageLoadResponse {
    val input = SetForceUpdateOnPageLoadRequest(forceUpdateOnPageLoad)
    return setForceUpdateOnPageLoad(input)
  }

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-skipWaiting)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun skipWaiting(input: SkipWaitingRequest): SkipWaitingResponse =
      session.request("ServiceWorker.skipWaiting", input)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-skipWaiting)
   */
  public suspend fun skipWaiting(scopeURL: String): SkipWaitingResponse {
    val input = SkipWaitingRequest(scopeURL)
    return skipWaiting(input)
  }

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-startWorker)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun startWorker(input: StartWorkerRequest): StartWorkerResponse =
      session.request("ServiceWorker.startWorker", input)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-startWorker)
   */
  public suspend fun startWorker(scopeURL: String): StartWorkerResponse {
    val input = StartWorkerRequest(scopeURL)
    return startWorker(input)
  }

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-stopAllWorkers)
   */
  public suspend fun stopAllWorkers(): StopAllWorkersResponse =
      session.request("ServiceWorker.stopAllWorkers", Unit)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-stopWorker)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun stopWorker(input: StopWorkerRequest): StopWorkerResponse =
      session.request("ServiceWorker.stopWorker", input)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-stopWorker)
   */
  public suspend fun stopWorker(versionId: String): StopWorkerResponse {
    val input = StopWorkerRequest(versionId)
    return stopWorker(input)
  }

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-unregister)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun unregister(input: UnregisterRequest): UnregisterResponse =
      session.request("ServiceWorker.unregister", input)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-unregister)
   */
  public suspend fun unregister(scopeURL: String): UnregisterResponse {
    val input = UnregisterRequest(scopeURL)
    return unregister(input)
  }

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-updateRegistration)
   *
   * Note: this function uses an input class, and constructing this class manually may lead to
   * incompatibilities if the class's constructor arguments change in the future. For maximum
   * compatibility, it is advised to use the overload of this function that directly takes the
   * mandatory parameters as arguments, and the optional ones from a configuration lambda.
   */
  public suspend fun updateRegistration(input: UpdateRegistrationRequest):
      UpdateRegistrationResponse = session.request("ServiceWorker.updateRegistration", input)

  /**
   *
   *
   * [Official doc](https://chromedevtools.github.io/devtools-protocol/tot/ServiceWorker/#method-updateRegistration)
   */
  public suspend fun updateRegistration(scopeURL: String): UpdateRegistrationResponse {
    val input = UpdateRegistrationRequest(scopeURL)
    return updateRegistration(input)
  }
}
